/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.amqp;

import com.primeton.pmq.broker.BrokerService;
import com.primeton.pmq.command.Command;
import com.primeton.pmq.transport.Transport;
import com.primeton.pmq.transport.TransportFilter;
import com.primeton.pmq.transport.TransportListener;
import com.primeton.pmq.transport.amqp.AmqpInactivityMonitor;
import com.primeton.pmq.transport.amqp.AmqpProtocolConverter;
import com.primeton.pmq.transport.amqp.AmqpProtocolDiscriminator;
import com.primeton.pmq.transport.amqp.AmqpTransport;
import com.primeton.pmq.transport.amqp.AmqpWireFormat;
import com.primeton.pmq.transport.nio.NIOSSLTransport;
import com.primeton.pmq.transport.tcp.SslTransport;
import com.primeton.pmq.util.IOExceptionSupport;
import com.primeton.pmq.wireformat.WireFormat;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpTransportFilter
extends TransportFilter
implements AmqpTransport {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpTransportFilter.class);
    static final Logger TRACE_BYTES = LoggerFactory.getLogger(AmqpTransportFilter.class.getPackage().getName() + ".BYTES");
    public static final Logger TRACE_FRAMES = LoggerFactory.getLogger(AmqpTransportFilter.class.getPackage().getName() + ".FRAMES");
    private AmqpProtocolConverter protocolConverter;
    private AmqpWireFormat wireFormat;
    private AmqpInactivityMonitor monitor;
    private boolean trace;
    private final ReentrantLock lock = new ReentrantLock();

    public AmqpTransportFilter(Transport next, WireFormat wireFormat, BrokerService brokerService) {
        super(next);
        this.protocolConverter = new AmqpProtocolDiscriminator(this, brokerService);
        if (wireFormat instanceof AmqpWireFormat) {
            this.wireFormat = (AmqpWireFormat)wireFormat;
        }
    }

    @Override
    public void start() throws Exception {
        if (this.monitor != null) {
            this.monitor.setAmqpTransport(this);
            this.monitor.startConnectionTimeoutChecker(this.getConnectAttemptTimeout());
        }
        super.start();
    }

    @Override
    public void oneway(Object o) throws IOException {
        try {
            Command command = (Command)o;
            this.lock.lock();
            try {
                this.protocolConverter.onPMQCommand(command);
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (Exception e) {
            throw IOExceptionSupport.create(e);
        }
    }

    @Override
    public void onException(IOException error) {
        this.lock.lock();
        try {
            this.protocolConverter.onAMQPException(error);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void sendToPMQ(IOException error) {
        super.onException(error);
    }

    @Override
    public void onCommand(Object command) {
        try {
            if (this.trace) {
                TRACE_BYTES.trace("Received: \n{}", command);
            }
            this.lock.lock();
            try {
                this.protocolConverter.onAMQPData(command);
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (IOException e) {
            this.handleException(e);
        }
        catch (Exception e) {
            this.onException(IOExceptionSupport.create(e));
        }
    }

    @Override
    public void sendToPMQ(Command command) {
        assert (this.lock.isHeldByCurrentThread());
        TransportListener l = this.transportListener;
        if (l != null) {
            l.onCommand(command);
        }
    }

    @Override
    public void sendToAmqp(Object command) throws IOException {
        Transport n;
        assert (this.lock.isHeldByCurrentThread());
        if (this.trace) {
            TRACE_BYTES.trace("Sending: \n{}", command);
        }
        if ((n = this.next) != null) {
            n.oneway(command);
        }
    }

    @Override
    public long keepAlive() {
        long nextKeepAliveDelay = 0L;
        try {
            this.lock.lock();
            try {
                nextKeepAliveDelay = this.protocolConverter.keepAlive();
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (IOException e) {
            this.handleException(e);
        }
        catch (Exception e) {
            this.onException(IOExceptionSupport.create(e));
        }
        return nextKeepAliveDelay;
    }

    @Override
    public X509Certificate[] getPeerCertificates() {
        X509Certificate[] peerCerts = null;
        if (this.next instanceof SslTransport) {
            peerCerts = ((SslTransport)this.next).getPeerCertificates();
        } else if (this.next instanceof NIOSSLTransport) {
            peerCerts = ((NIOSSLTransport)this.next).getPeerCertificates();
        }
        if (this.trace && peerCerts != null) {
            LOG.debug("Peer Identity has been verified\n");
        }
        return peerCerts;
    }

    @Override
    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
        this.protocolConverter.updateTracer();
    }

    @Override
    public AmqpWireFormat getWireFormat() {
        return this.wireFormat;
    }

    public void handleException(IOException e) {
        super.onException(e);
    }

    @Override
    public String getTransformer() {
        return this.wireFormat.getTransformer();
    }

    public void setTransformer(String transformer) {
        this.wireFormat.setTransformer(transformer);
    }

    @Override
    public AmqpProtocolConverter getProtocolConverter() {
        return this.protocolConverter;
    }

    @Override
    public void setProtocolConverter(AmqpProtocolConverter protocolConverter) {
        this.protocolConverter = protocolConverter;
    }

    public void setProducerCredit(int producerCredit) {
        this.wireFormat.setProducerCredit(producerCredit);
    }

    public int getProducerCredit() {
        return this.wireFormat.getProducerCredit();
    }

    @Override
    public void setInactivityMonitor(AmqpInactivityMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public AmqpInactivityMonitor getInactivityMonitor() {
        return this.monitor;
    }

    @Override
    public boolean isUseInactivityMonitor() {
        return this.monitor != null;
    }

    public int getConnectAttemptTimeout() {
        return this.wireFormat.getConnectAttemptTimeout();
    }

    public void setConnectAttemptTimeout(int connectAttemptTimeout) {
        this.wireFormat.setConnectAttemptTimeout(connectAttemptTimeout);
    }

    public long getMaxFrameSize() {
        return this.wireFormat.getMaxFrameSize();
    }

    public void setMaxFrameSize(long maxFrameSize) {
        this.wireFormat.setMaxFrameSize(maxFrameSize);
    }
}

