/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.amqp.message;

import com.primeton.pmq.command.PMQBytesMessage;
import com.primeton.pmq.command.PMQMessage;
import com.primeton.pmq.transport.amqp.message.AmqpMessageSupport;
import com.primeton.pmq.transport.amqp.message.AmqpWritableBuffer;
import com.primeton.pmq.transport.amqp.message.EncodedMessage;
import com.primeton.pmq.transport.amqp.message.OutboundTransformer;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.message.Message;
import org.apache.qpid.proton.message.ProtonJMessage;

public class AMQPNativeOutboundTransformer
implements OutboundTransformer {
    @Override
    public EncodedMessage transform(PMQMessage message) throws Exception {
        if (message == null || !(message instanceof PMQBytesMessage)) {
            return null;
        }
        return AMQPNativeOutboundTransformer.transform(this, (PMQBytesMessage)message);
    }

    static EncodedMessage transform(OutboundTransformer options, PMQBytesMessage message) throws JMSException {
        long messageFormat;
        if (message.propertyExists("JMS_AMQP_MESSAGE_FORMAT")) {
            try {
                messageFormat = message.getLongProperty("JMS_AMQP_MESSAGE_FORMAT");
            }
            catch (MessageFormatException e) {
                return null;
            }
        } else {
            messageFormat = 0L;
        }
        Binary encodedMessage = AmqpMessageSupport.getBinaryFromMessageBody(message);
        byte[] encodedData = encodedMessage.getArray();
        int encodedSize = encodedMessage.getLength();
        int count = message.getRedeliveryCounter();
        if (count >= 1) {
            int decoded;
            ProtonJMessage amqp = (ProtonJMessage)Message.Factory.create();
            int offset = 0;
            for (int len = encodedSize; len > 0; len -= decoded) {
                decoded = amqp.decode(encodedData, offset, len);
                assert (decoded > 0) : "Make progress decoding the message";
                offset += decoded;
            }
            if (amqp.getHeader() == null) {
                amqp.setHeader(new Header());
            }
            amqp.getHeader().setDeliveryCount(new UnsignedInteger(count));
            AmqpWritableBuffer buffer = new AmqpWritableBuffer();
            int written = amqp.encode((WritableBuffer)buffer);
            encodedData = buffer.getArray();
            encodedSize = written;
        }
        return new EncodedMessage(messageFormat, encodedData, 0, encodedSize);
    }
}

