/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.amqp.message;

import com.primeton.pmq.command.PMQBytesMessage;
import com.primeton.pmq.command.PMQMessage;
import com.primeton.pmq.transport.amqp.message.EncodedMessage;
import com.primeton.pmq.transport.amqp.message.InboundTransformer;
import com.primeton.pmq.util.ByteSequence;

public class AMQPRawInboundTransformer
extends InboundTransformer {
    @Override
    public String getTransformerName() {
        return "raw";
    }

    @Override
    public InboundTransformer getFallbackTransformer() {
        return null;
    }

    @Override
    protected PMQMessage doTransform(EncodedMessage amqpMessage) throws Exception {
        PMQBytesMessage result = new PMQBytesMessage();
        result.setContent(new ByteSequence(amqpMessage.getArray(), amqpMessage.getArrayOffset(), amqpMessage.getLength()));
        result.setPersistent(true);
        result.setPriority((byte)4);
        long now = System.currentTimeMillis();
        result.setTimestamp(now);
        if (amqpMessage.getMessageFormat() != 0L) {
            result.setLongProperty("JMS_AMQP_MESSAGE_FORMAT", amqpMessage.getMessageFormat());
        }
        result.setBooleanProperty("JMS_AMQP_NATIVE", true);
        return result;
    }
}

