/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.amqp.protocol;

import com.primeton.pmq.command.LocalTransactionId;
import com.primeton.pmq.transport.amqp.AmqpProtocolException;
import com.primeton.pmq.transport.amqp.protocol.AmqpAbstractLink;
import com.primeton.pmq.transport.amqp.protocol.AmqpSession;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Receiver;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AmqpAbstractReceiver
extends AmqpAbstractLink<Receiver> {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpAbstractReceiver.class);
    protected ByteArrayOutputStream current = new ByteArrayOutputStream();
    protected final byte[] recvBuffer = new byte[8192];
    protected final int configuredCredit;

    public AmqpAbstractReceiver(AmqpSession session, Receiver endpoint) {
        super(session, endpoint);
        this.configuredCredit = session.getConnection().getConfiguredReceiverCredit();
        ((Receiver)this.endpoint).setReceiverSettleMode(ReceiverSettleMode.FIRST);
        ((Receiver)this.endpoint).setSenderSettleMode(endpoint.getRemoteSenderSettleMode());
    }

    @Override
    public void detach() {
    }

    @Override
    public void flow() throws Exception {
    }

    public int getConfiguredReceiverCredit() {
        return this.configuredCredit;
    }

    public void flow(int credits) {
        ((Receiver)this.getEndpoint()).flow(credits);
    }

    @Override
    public void commit(LocalTransactionId txnId) throws Exception {
    }

    @Override
    public void rollback(LocalTransactionId txnId) throws Exception {
    }

    @Override
    public void delivery(Delivery delivery) throws Exception {
        int count;
        if (!delivery.isReadable()) {
            LOG.debug("Delivery was not readable!");
            return;
        }
        if (this.current == null) {
            this.current = new ByteArrayOutputStream();
        }
        while ((count = ((Receiver)this.getEndpoint()).recv(this.recvBuffer, 0, this.recvBuffer.length)) > 0) {
            this.current.write(this.recvBuffer, 0, count);
            if ((long)this.current.size() <= this.session.getMaxFrameSize()) continue;
            throw new AmqpProtocolException("Frame size of " + this.current.size() + " larger than max allowed " + this.session.getMaxFrameSize());
        }
        if (count == 0) {
            return;
        }
        try {
            this.processDelivery(delivery, this.current.toBuffer());
        }
        finally {
            ((Receiver)this.getEndpoint()).advance();
            this.current = null;
        }
    }

    protected abstract void processDelivery(Delivery var1, Buffer var2) throws Exception;
}

