/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.amqp.protocol;

import java.util.ArrayDeque;
import java.util.Deque;

public final class AmqpTransferTagGenerator {
    public static final int DEFAULT_TAG_POOL_SIZE = 1024;
    private final Deque<byte[]> tagPool;
    private long nextTagId;
    private int maxPoolSize = 1024;

    public AmqpTransferTagGenerator() {
        this(true);
    }

    public AmqpTransferTagGenerator(boolean pool) {
        this.tagPool = pool ? new ArrayDeque<byte[]>() : null;
    }

    public byte[] getNextTag() {
        byte[] tagBytes = null;
        if (this.tagPool != null) {
            tagBytes = this.tagPool.pollFirst();
        }
        if (tagBytes == null) {
            long tag = this.nextTagId++;
            int size2 = this.encodingSize(tag);
            tagBytes = new byte[size2];
            for (int i = 0; i < size2; ++i) {
                tagBytes[size2 - 1 - i] = (byte)(tag >>> i * 8);
            }
        }
        return tagBytes;
    }

    public void returnTag(byte[] data) {
        if (this.tagPool != null && this.tagPool.size() < this.maxPoolSize) {
            this.tagPool.offerLast(data);
        }
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public boolean isPooling() {
        return this.tagPool != null;
    }

    private int encodingSize(long value) {
        int size2;
        if (value < 0L) {
            return 8;
        }
        for (size2 = 1; size2 < 8 && value >= 1L << size2 * 8; ++size2) {
        }
        return size2;
    }
}

