/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.auto;

import com.primeton.pmq.broker.BrokerService;
import com.primeton.pmq.transport.auto.AutoTcpTransportServer;
import com.primeton.pmq.transport.tcp.SslTransportFactory;
import com.primeton.pmq.transport.tcp.TcpTransport;
import com.primeton.pmq.transport.tcp.TcpTransportFactory;
import com.primeton.pmq.wireformat.WireFormat;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public class AutoSslTransportServer
extends AutoTcpTransportServer {
    private boolean needClientAuth;
    private boolean wantClientAuth;

    public AutoSslTransportServer(SslTransportFactory transportFactory, URI location, SSLServerSocketFactory serverSocketFactory, BrokerService brokerService, Set<String> enabledProtocols) throws IOException, URISyntaxException {
        super(transportFactory, location, serverSocketFactory, brokerService, enabledProtocols);
    }

    public void setNeedClientAuth(boolean needAuth) {
        this.needClientAuth = needAuth;
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantAuth) {
        this.wantClientAuth = wantAuth;
    }

    @Override
    public void bind() throws IOException {
        super.bind();
        if (this.needClientAuth) {
            ((SSLServerSocket)this.serverSocket).setNeedClientAuth(true);
        } else if (this.wantClientAuth) {
            ((SSLServerSocket)this.serverSocket).setWantClientAuth(true);
        }
    }

    @Override
    protected TcpTransport createTransport(Socket socket, WireFormat format2, TcpTransportFactory detectedTransportFactory, TcpTransport.InitBuffer initBuffer) throws IOException {
        return detectedTransportFactory.createTransport(format2, socket, initBuffer);
    }

    @Override
    public boolean isSslServer() {
        return true;
    }
}

