/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.auto;

import com.primeton.pmq.broker.BrokerService;
import com.primeton.pmq.broker.BrokerServiceAware;
import com.primeton.pmq.openwire.OpenWireFormatFactory;
import com.primeton.pmq.transport.TransportServer;
import com.primeton.pmq.transport.auto.AutoTcpTransportServer;
import com.primeton.pmq.transport.auto.AutoTransportUtils;
import com.primeton.pmq.transport.tcp.TcpTransport;
import com.primeton.pmq.transport.tcp.TcpTransportFactory;
import com.primeton.pmq.transport.tcp.TcpTransportServer;
import com.primeton.pmq.util.IOExceptionSupport;
import com.primeton.pmq.util.IntrospectionSupport;
import com.primeton.pmq.util.URISupport;
import com.primeton.pmq.wireformat.WireFormat;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.net.ServerSocketFactory;

public class AutoTcpTransportFactory
extends TcpTransportFactory
implements BrokerServiceAware {
    protected BrokerService brokerService;
    boolean allowLinkStealingSet = false;
    private Set<String> enabledProtocols;

    @Override
    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    @Override
    public TransportServer doBind(URI location) throws IOException {
        try {
            HashMap<String, String> options = new HashMap<String, String>(URISupport.parseParameters(location));
            Map<String, Object> autoProperties = IntrospectionSupport.extractProperties(options, "auto.");
            this.enabledProtocols = AutoTransportUtils.parseProtocols((String)autoProperties.get("protocols"));
            ServerSocketFactory serverSocketFactory = this.createServerSocketFactory();
            AutoTcpTransportServer server = this.createTcpTransportServer(location, serverSocketFactory);
            server.setWireFormatFactory(new OpenWireFormatFactory());
            if (options.get("allowLinkStealing") != null) {
                this.allowLinkStealingSet = true;
            }
            IntrospectionSupport.setProperties(server, options);
            server.setTransportOption(IntrospectionSupport.extractProperties(options, "transport."));
            server.setWireFormatOptions(AutoTransportUtils.extractWireFormatOptions(options));
            server.bind();
            return server;
        }
        catch (URISyntaxException e) {
            throw IOExceptionSupport.create(e);
        }
    }

    @Override
    protected AutoTcpTransportServer createTcpTransportServer(URI location, ServerSocketFactory serverSocketFactory) throws IOException, URISyntaxException {
        AutoTcpTransportServer server = new AutoTcpTransportServer(this, location, serverSocketFactory, this.brokerService, this.enabledProtocols){

            @Override
            protected TcpTransport createTransport(Socket socket, WireFormat format2, TcpTransportFactory detectedTransportFactory, TcpTransport.InitBuffer initBuffer) throws IOException {
                AutoTcpTransportFactory.this.setDefaultLinkStealing(format2, this);
                return super.createTransport(socket, format2, detectedTransportFactory, initBuffer);
            }
        };
        return server;
    }

    private void setDefaultLinkStealing(WireFormat format2, TcpTransportServer server) {
        if (format2.getClass().toString().contains("MQTT") && !this.allowLinkStealingSet) {
            server.setAllowLinkStealing(true);
        }
    }
}

