/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.discovery;

import com.primeton.pmq.transport.CompositeTransport;
import com.primeton.pmq.transport.Transport;
import com.primeton.pmq.transport.TransportServer;
import com.primeton.pmq.transport.discovery.DiscoveryAgent;
import com.primeton.pmq.transport.discovery.DiscoveryAgentFactory;
import com.primeton.pmq.transport.discovery.DiscoveryTransport;
import com.primeton.pmq.transport.failover.FailoverTransport;
import com.primeton.pmq.transport.failover.FailoverTransportFactory;
import com.primeton.pmq.util.IntrospectionSupport;
import com.primeton.pmq.util.URISupport;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class DiscoveryTransportFactory
extends FailoverTransportFactory {
    @Override
    public Transport createTransport(URISupport.CompositeData compositeData) throws IOException {
        HashMap<String, String> parameters = new HashMap<String, String>(compositeData.getParameters());
        FailoverTransport failoverTransport = this.createTransport(parameters);
        return DiscoveryTransportFactory.createTransport(failoverTransport, compositeData, parameters);
    }

    public static DiscoveryTransport createTransport(CompositeTransport compositeTransport, URISupport.CompositeData compositeData, Map<String, String> parameters) throws IOException {
        DiscoveryTransport transport = new DiscoveryTransport(compositeTransport);
        IntrospectionSupport.setProperties(transport, parameters);
        transport.setParameters(parameters);
        URI discoveryAgentURI = compositeData.getComponents()[0];
        DiscoveryAgent discoveryAgent = DiscoveryAgentFactory.createDiscoveryAgent(discoveryAgentURI);
        transport.setDiscoveryAgent(discoveryAgent);
        return transport;
    }

    @Override
    public TransportServer doBind(URI location) throws IOException {
        throw new IOException("Invalid server URI: " + location);
    }
}

