/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.discovery.multicast;

import com.primeton.pmq.transport.discovery.DiscoveryAgent;
import com.primeton.pmq.transport.discovery.DiscoveryAgentFactory;
import com.primeton.pmq.transport.discovery.multicast.MulticastDiscoveryAgent;
import com.primeton.pmq.util.IOExceptionSupport;
import com.primeton.pmq.util.IntrospectionSupport;
import com.primeton.pmq.util.URISupport;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MulticastDiscoveryAgentFactory
extends DiscoveryAgentFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MulticastDiscoveryAgentFactory.class);

    @Override
    protected DiscoveryAgent doCreateDiscoveryAgent(URI uri) throws IOException {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("doCreateDiscoveryAgent: uri = " + uri.toString());
            }
            MulticastDiscoveryAgent mda = new MulticastDiscoveryAgent();
            mda.setDiscoveryURI(uri);
            Map<String, String> options = URISupport.parseParameters(uri);
            IntrospectionSupport.setProperties(mda, options);
            return mda;
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create("Could not create discovery agent: " + uri, e);
        }
    }
}

