/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.https;

import com.primeton.pmq.broker.SslContext;
import com.primeton.pmq.transport.http.HttpClientTransport;
import com.primeton.pmq.transport.util.TextWireFormat;
import com.primeton.pmq.util.IOExceptionSupport;
import java.io.IOException;
import java.net.URI;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class HttpsClientTransport
extends HttpClientTransport {
    private final SSLSocketFactory sslSocketFactory;
    private boolean verifyHostName = true;

    public HttpsClientTransport(TextWireFormat wireFormat, URI remoteUrl) {
        super(wireFormat, remoteUrl);
        try {
            this.sslSocketFactory = this.createSocketFactory();
        }
        catch (IOException e) {
            throw new IllegalStateException("Error trying to configure TLS", e);
        }
    }

    @Override
    protected HttpClientConnectionManager createClientConnectionManager() {
        return new PoolingHttpClientConnectionManager(this.createRegistry());
    }

    private Registry<ConnectionSocketFactory> createRegistry() {
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        try {
            DefaultHostnameVerifier hostnameVerifier = this.verifyHostName ? new DefaultHostnameVerifier() : new NoopHostnameVerifier();
            SSLConnectionSocketFactory sslConnectionFactory = new SSLConnectionSocketFactory(this.sslSocketFactory, (HostnameVerifier)hostnameVerifier);
            registryBuilder.register("https", (Object)sslConnectionFactory);
            return registryBuilder.build();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failure trying to create scheme registry", e);
        }
    }

    protected SSLSocketFactory createSocketFactory() throws IOException {
        if (SslContext.getCurrentSslContext() != null) {
            SslContext ctx = SslContext.getCurrentSslContext();
            try {
                return ctx.getSSLContext().getSocketFactory();
            }
            catch (Exception e) {
                throw IOExceptionSupport.create(e);
            }
        }
        return (SSLSocketFactory)SSLSocketFactory.getDefault();
    }

    @Override
    protected String getSystemPropertyPrefix() {
        return "https.";
    }

    public Boolean getVerifyHostName() {
        return this.verifyHostName;
    }

    public void setVerifyHostName(Boolean verifyHostName) {
        this.verifyHostName = verifyHostName;
    }
}

