/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.mqtt;

import com.primeton.pmq.transport.mqtt.MQTTProtocolException;
import java.io.UnsupportedEncodingException;

public class MQTTProtocolSupport {
    private static final int TOPIC_NAME_MIN_LENGTH = 1;
    private static final int TOPIC_NAME_MAX_LENGTH = 65535;
    private static final String MULTI_LEVEL_WILDCARD = "#";
    private static final String SINGLE_LEVEL_WILDCARD = "+";
    private static final char MULTI_LEVEL_WILDCARD_CHAR = '#';
    private static final char SINGLE_LEVEL_WILDCARD_CHAR = '+';
    private static final char TOPIC_LEVEL_SEPERATOR_CHAR = '/';

    public static String convertMQTTToPMQ(String name) {
        char[] chars = name.toCharArray();
        block8: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '#': {
                    chars[i] = 62;
                    continue block8;
                }
                case '>': {
                    chars[i] = 35;
                    continue block8;
                }
                case '+': {
                    chars[i] = 42;
                    continue block8;
                }
                case '*': {
                    chars[i] = 43;
                    continue block8;
                }
                case '/': {
                    chars[i] = 46;
                    continue block8;
                }
                case '.': {
                    chars[i] = 47;
                }
            }
        }
        String rc = new String(chars);
        return rc;
    }

    public static String convertPMQToMQTT(String destinationName) {
        char[] chars = destinationName.toCharArray();
        block8: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '>': {
                    chars[i] = 35;
                    continue block8;
                }
                case '#': {
                    chars[i] = 62;
                    continue block8;
                }
                case '*': {
                    chars[i] = 43;
                    continue block8;
                }
                case '+': {
                    chars[i] = 42;
                    continue block8;
                }
                case '.': {
                    chars[i] = 47;
                    continue block8;
                }
                case '/': {
                    chars[i] = 46;
                }
            }
        }
        String rc = new String(chars);
        return rc;
    }

    public static String commandType(byte header) {
        byte messageType = (byte)((header & 0xF0) >>> 4);
        switch (messageType) {
            case 12: {
                return "PINGREQ";
            }
            case 1: {
                return "CONNECT";
            }
            case 14: {
                return "DISCONNECT";
            }
            case 8: {
                return "SUBSCRIBE";
            }
            case 10: {
                return "UNSUBSCRIBE";
            }
            case 3: {
                return "PUBLISH";
            }
            case 4: {
                return "PUBACK";
            }
            case 5: {
                return "PUBREC";
            }
            case 6: {
                return "PUBREL";
            }
            case 7: {
                return "PUBCOMP";
            }
        }
        return "UNKNOWN";
    }

    public static void validate(String topicName) throws MQTTProtocolException {
        int i;
        int topicLen = 0;
        try {
            topicLen = topicName.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            throw new MQTTProtocolException("Topic name contained invalid UTF-8 encoding.");
        }
        if (topicLen < 1 || topicLen > 65535) {
            throw new MQTTProtocolException("Topic name given had invliad length.");
        }
        if (MULTI_LEVEL_WILDCARD.equals(topicName) || SINGLE_LEVEL_WILDCARD.equals(topicName)) {
            return;
        }
        int numWildCards = 0;
        for (i = 0; i < topicName.length(); ++i) {
            if (topicName.charAt(i) == '#') {
                ++numWildCards;
                if (i > 0 && topicName.charAt(i - 1) != '/') {
                    throw new MQTTProtocolException("The multi level wildcard must stand alone: " + topicName);
                }
            }
            if (numWildCards <= 1) continue;
            throw new MQTTProtocolException("Topic Filter can only have one multi-level filter: " + topicName);
        }
        if (topicName.contains(MULTI_LEVEL_WILDCARD) && !topicName.endsWith(MULTI_LEVEL_WILDCARD)) {
            throw new MQTTProtocolException("The multi-level filter must be at the end of the Topic name: " + topicName);
        }
        for (i = 0; i < topicName.length(); ++i) {
            if (topicName.charAt(i) != '+') continue;
            if (i > 0 && topicName.charAt(i - 1) != '/') {
                throw new MQTTProtocolException("The single level wildcard must stand alone: " + topicName);
            }
            if (i >= topicName.length() - 1 || topicName.charAt(i + 1) == '/') continue;
            throw new MQTTProtocolException("The single level wildcard must stand alone: " + topicName);
        }
    }
}

