/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.mqtt;

import com.primeton.pmq.command.ConsumerInfo;
import com.primeton.pmq.command.MessageAck;
import com.primeton.pmq.command.MessageDispatch;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.command.PMQMessage;
import com.primeton.pmq.transport.mqtt.MQTTProtocolConverter;
import java.io.IOException;
import java.util.zip.DataFormatException;
import javax.jms.JMSException;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.codec.PUBLISH;

public class MQTTSubscription {
    private final MQTTProtocolConverter protocolConverter;
    private final ConsumerInfo consumerInfo;
    private final String topicName;
    private final QoS qos;

    public MQTTSubscription(MQTTProtocolConverter protocolConverter, String topicName, QoS qos, ConsumerInfo consumerInfo) {
        this.protocolConverter = protocolConverter;
        this.consumerInfo = consumerInfo;
        this.qos = qos;
        this.topicName = topicName;
    }

    public MessageAck createMessageAck(MessageDispatch md) {
        return new MessageAck(md, 4, 1);
    }

    public PUBLISH createPublish(PMQMessage message) throws DataFormatException, IOException, JMSException {
        PUBLISH publish = this.protocolConverter.convertMessage(message);
        if (publish.qos().ordinal() > this.qos.ordinal()) {
            publish.qos(this.qos);
        }
        switch (publish.qos()) {
            case AT_LEAST_ONCE: 
            case EXACTLY_ONCE: {
                this.protocolConverter.getPacketIdGenerator().setPacketId(this.protocolConverter.getClientId(), this, message, publish);
            }
        }
        return publish;
    }

    public boolean expectAck(PUBLISH publish) {
        QoS publishQoS = publish.qos();
        if (publishQoS.compareTo((Enum)this.qos) > 0) {
            publishQoS = this.qos;
        }
        return !publishQoS.equals((Object)QoS.AT_MOST_ONCE);
    }

    public String getTopicName() {
        return this.topicName;
    }

    public PMQDestination getDestination() {
        return this.consumerInfo.getDestination();
    }

    public ConsumerInfo getConsumerInfo() {
        return this.consumerInfo;
    }

    public QoS getQoS() {
        return this.qos;
    }

    public String toString() {
        return "MQTT Sub: topic[" + this.topicName + "] -> [" + this.consumerInfo.getDestination() + "]";
    }
}

