/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.mqtt.strategy;

import com.primeton.pmq.command.ConsumerInfo;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.command.PMQTopic;
import com.primeton.pmq.command.RemoveSubscriptionInfo;
import com.primeton.pmq.command.Response;
import com.primeton.pmq.command.SubscriptionInfo;
import com.primeton.pmq.transport.mqtt.MQTTProtocolConverter;
import com.primeton.pmq.transport.mqtt.MQTTProtocolException;
import com.primeton.pmq.transport.mqtt.MQTTProtocolSupport;
import com.primeton.pmq.transport.mqtt.MQTTSubscription;
import com.primeton.pmq.transport.mqtt.ResponseHandler;
import com.primeton.pmq.transport.mqtt.strategy.AbstractMQTTSubscriptionStrategy;
import java.io.IOException;
import java.util.List;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.codec.CONNECT;

public class MQTTDefaultSubscriptionStrategy
extends AbstractMQTTSubscriptionStrategy {
    @Override
    public void onConnect(CONNECT connect) throws MQTTProtocolException {
        List<SubscriptionInfo> subs = this.lookupSubscription(this.protocol.getClientId());
        if (connect.cleanSession()) {
            this.deleteDurableSubs(subs);
        } else {
            this.restoreDurableSubs(subs);
        }
    }

    @Override
    public byte onSubscribe(String topicName, QoS requestedQoS) throws MQTTProtocolException {
        PMQTopic destination = new PMQTopic(MQTTProtocolSupport.convertMQTTToPMQ(topicName));
        ConsumerInfo consumerInfo = new ConsumerInfo(this.getNextConsumerId());
        consumerInfo.setDestination(destination);
        consumerInfo.setPrefetchSize(Short.MAX_VALUE);
        consumerInfo.setRetroactive(true);
        consumerInfo.setDispatchAsync(true);
        if (!this.protocol.isCleanSession() && this.protocol.getClientId() != null && requestedQoS.ordinal() >= QoS.AT_LEAST_ONCE.ordinal()) {
            consumerInfo.setSubscriptionName(requestedQoS + ":" + topicName);
            consumerInfo.setPrefetchSize(100);
        }
        if (this.protocol.getPMQSubscriptionPrefetch() > 0) {
            consumerInfo.setPrefetchSize(this.protocol.getPMQSubscriptionPrefetch());
        }
        return this.doSubscribe(consumerInfo, topicName, requestedQoS);
    }

    @Override
    public void onReSubscribe(MQTTSubscription mqttSubscription) throws MQTTProtocolException {
        PMQDestination destination = mqttSubscription.getDestination();
        if (this.restoredDurableSubs.remove(destination.getPhysicalName())) {
            return;
        }
        super.onReSubscribe(mqttSubscription);
    }

    @Override
    public void onUnSubscribe(String topicName) throws MQTTProtocolException {
        MQTTSubscription subscription = (MQTTSubscription)this.mqttSubscriptionByTopic.remove(topicName);
        if (subscription != null) {
            this.doUnSubscribe(subscription);
            if (subscription.getConsumerInfo().getSubscriptionName() != null) {
                this.restoredDurableSubs.remove(MQTTProtocolSupport.convertMQTTToPMQ(subscription.getTopicName()));
                RemoveSubscriptionInfo rsi = new RemoveSubscriptionInfo();
                rsi.setConnectionId(this.protocol.getConnectionId());
                rsi.setSubscriptionName(subscription.getConsumerInfo().getSubscriptionName());
                rsi.setClientId(this.protocol.getClientId());
                this.protocol.sendToPMQ(rsi, new ResponseHandler(){

                    @Override
                    public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                    }
                });
            }
        }
    }
}

