/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.mqtt.strategy;

import com.primeton.pmq.broker.region.QueueRegion;
import com.primeton.pmq.broker.region.RegionBroker;
import com.primeton.pmq.command.ConsumerInfo;
import com.primeton.pmq.command.DestinationInfo;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.command.PMQQueue;
import com.primeton.pmq.command.PMQTopic;
import com.primeton.pmq.command.RemoveSubscriptionInfo;
import com.primeton.pmq.command.Response;
import com.primeton.pmq.command.SubscriptionInfo;
import com.primeton.pmq.transport.mqtt.MQTTProtocolConverter;
import com.primeton.pmq.transport.mqtt.MQTTProtocolException;
import com.primeton.pmq.transport.mqtt.MQTTProtocolSupport;
import com.primeton.pmq.transport.mqtt.MQTTSubscription;
import com.primeton.pmq.transport.mqtt.ResponseHandler;
import com.primeton.pmq.transport.mqtt.strategy.AbstractMQTTSubscriptionStrategy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.codec.CONNECT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTVirtualTopicSubscriptionStrategy
extends AbstractMQTTSubscriptionStrategy {
    private static final String VIRTUALTOPIC_PREFIX = "VirtualTopic.";
    private static final String VIRTUALTOPIC_CONSUMER_PREFIX = "Consumer.";
    private static final Logger LOG = LoggerFactory.getLogger(MQTTVirtualTopicSubscriptionStrategy.class);
    private final Set<PMQQueue> restoredQueues = Collections.synchronizedSet(new HashSet());

    @Override
    public void onConnect(CONNECT connect) throws MQTTProtocolException {
        List<PMQQueue> queues = this.lookupQueues(this.protocol.getClientId());
        List<SubscriptionInfo> subs = this.lookupSubscription(this.protocol.getClientId());
        if (connect.cleanSession()) {
            this.deleteDurableQueues(queues);
            this.deleteDurableSubs(subs);
        } else {
            this.restoreDurableQueue(queues);
            this.restoreDurableSubs(subs);
        }
    }

    @Override
    public byte onSubscribe(String topicName, QoS requestedQoS) throws MQTTProtocolException {
        PMQDestination destination = null;
        int prefetch = 1000;
        ConsumerInfo consumerInfo = new ConsumerInfo(this.getNextConsumerId());
        String converted = MQTTProtocolSupport.convertMQTTToPMQ(topicName);
        if (!this.protocol.isCleanSession() && this.protocol.getClientId() != null && requestedQoS.ordinal() >= QoS.AT_LEAST_ONCE.ordinal()) {
            if (converted.startsWith(VIRTUALTOPIC_PREFIX)) {
                destination = new PMQTopic(converted);
                prefetch = 100;
                consumerInfo.setSubscriptionName(requestedQoS + ":" + topicName);
            } else {
                converted = VIRTUALTOPIC_CONSUMER_PREFIX + MQTTProtocolSupport.convertMQTTToPMQ(this.protocol.getClientId()) + ":" + requestedQoS + "." + VIRTUALTOPIC_PREFIX + converted;
                destination = new PMQQueue(converted);
                prefetch = 1000;
            }
        } else {
            if (!converted.startsWith(VIRTUALTOPIC_PREFIX)) {
                converted = VIRTUALTOPIC_PREFIX + converted;
            }
            destination = new PMQTopic(converted);
            prefetch = Short.MAX_VALUE;
        }
        consumerInfo.setDestination(destination);
        if (this.protocol.getPMQSubscriptionPrefetch() > 0) {
            consumerInfo.setPrefetchSize(this.protocol.getPMQSubscriptionPrefetch());
        } else {
            consumerInfo.setPrefetchSize(prefetch);
        }
        consumerInfo.setRetroactive(true);
        consumerInfo.setDispatchAsync(true);
        return this.doSubscribe(consumerInfo, topicName, requestedQoS);
    }

    @Override
    public void onReSubscribe(MQTTSubscription mqttSubscription) throws MQTTProtocolException {
        PMQDestination destination = mqttSubscription.getDestination();
        if (destination.isQueue() && this.restoredQueues.remove(destination)) {
            return;
        }
        if (destination.isTopic() && this.restoredDurableSubs.remove(destination.getPhysicalName())) {
            return;
        }
        if (mqttSubscription.getDestination().isTopic()) {
            super.onReSubscribe(mqttSubscription);
        } else {
            this.doUnSubscribe(mqttSubscription);
            ConsumerInfo consumerInfo = mqttSubscription.getConsumerInfo();
            consumerInfo.setConsumerId(this.getNextConsumerId());
            this.doSubscribe(consumerInfo, mqttSubscription.getTopicName(), mqttSubscription.getQoS());
        }
    }

    @Override
    public void onUnSubscribe(String topicName) throws MQTTProtocolException {
        MQTTSubscription subscription = (MQTTSubscription)this.mqttSubscriptionByTopic.remove(topicName);
        if (subscription != null) {
            this.doUnSubscribe(subscription);
            if (subscription.getDestination().isQueue()) {
                DestinationInfo remove2 = new DestinationInfo();
                remove2.setConnectionId(this.protocol.getConnectionId());
                remove2.setDestination(subscription.getDestination());
                remove2.setOperationType((byte)1);
                this.protocol.sendToPMQ(remove2, new ResponseHandler(){

                    @Override
                    public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                    }
                });
            } else if (subscription.getConsumerInfo().getSubscriptionName() != null) {
                this.restoredDurableSubs.remove(MQTTProtocolSupport.convertMQTTToPMQ(subscription.getTopicName()));
                RemoveSubscriptionInfo rsi = new RemoveSubscriptionInfo();
                rsi.setConnectionId(this.protocol.getConnectionId());
                rsi.setSubscriptionName(subscription.getConsumerInfo().getSubscriptionName());
                rsi.setClientId(this.protocol.getClientId());
                this.protocol.sendToPMQ(rsi, new ResponseHandler(){

                    @Override
                    public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                    }
                });
            }
        }
    }

    @Override
    public PMQDestination onSend(String topicName) {
        PMQTopic topic = new PMQTopic(topicName);
        if (topic.isComposite()) {
            PMQDestination[] composites;
            for (PMQDestination composite : composites = topic.getCompositeDestinations()) {
                composite.setPhysicalName(this.prefix(composite.getPhysicalName()));
            }
            PMQTopic result = new PMQTopic();
            result.setCompositeDestinations(composites);
            return result;
        }
        return new PMQTopic(this.prefix(topicName));
    }

    private String prefix(String topicName) {
        if (!topicName.startsWith(VIRTUALTOPIC_PREFIX)) {
            return VIRTUALTOPIC_PREFIX + topicName;
        }
        return topicName;
    }

    @Override
    public String onSend(PMQDestination destination) {
        String destinationName = destination.getPhysicalName();
        int position = destinationName.indexOf(VIRTUALTOPIC_PREFIX);
        if (position >= 0) {
            destinationName = destinationName.substring(position + VIRTUALTOPIC_PREFIX.length()).substring(0);
        }
        return destinationName;
    }

    @Override
    public boolean isControlTopic(PMQDestination destination) {
        String destinationName = destination.getPhysicalName();
        return destinationName.startsWith("$") || destinationName.startsWith("VirtualTopic.$");
    }

    private void deleteDurableQueues(List<PMQQueue> queues) {
        try {
            for (PMQQueue queue2 : queues) {
                LOG.debug("Removing queue subscription for {} ", (Object)queue2.getPhysicalName());
                DestinationInfo removeAction = new DestinationInfo();
                removeAction.setConnectionId(this.protocol.getConnectionId());
                removeAction.setDestination(queue2);
                removeAction.setOperationType((byte)1);
                this.protocol.sendToPMQ(removeAction, new ResponseHandler(){

                    @Override
                    public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                    }
                });
            }
        }
        catch (Throwable e) {
            LOG.warn("Could not delete the MQTT queue subscriptions.", e);
        }
    }

    private void restoreDurableQueue(List<PMQQueue> queues) {
        try {
            for (PMQQueue queue2 : queues) {
                String name = queue2.getPhysicalName().substring(VIRTUALTOPIC_CONSUMER_PREFIX.length());
                StringTokenizer tokenizer = new StringTokenizer(name);
                tokenizer.nextToken(":.");
                String qosString = tokenizer.nextToken();
                tokenizer.nextToken();
                String topicName = MQTTProtocolSupport.convertPMQToMQTT(tokenizer.nextToken("").substring(1));
                QoS qoS = QoS.valueOf((String)qosString);
                LOG.trace("Restoring queue subscription: {}:{}", (Object)topicName, (Object)qoS);
                ConsumerInfo consumerInfo = new ConsumerInfo(this.getNextConsumerId());
                consumerInfo.setDestination(queue2);
                consumerInfo.setPrefetchSize(1000);
                if (this.protocol.getPMQSubscriptionPrefetch() > 0) {
                    consumerInfo.setPrefetchSize(this.protocol.getPMQSubscriptionPrefetch());
                }
                consumerInfo.setRetroactive(true);
                consumerInfo.setDispatchAsync(true);
                this.doSubscribe(consumerInfo, topicName, qoS);
                this.restoredQueues.add(queue2);
            }
        }
        catch (IOException e) {
            LOG.warn("Could not restore the MQTT queue subscriptions.", e);
        }
    }

    List<PMQQueue> lookupQueues(String clientId) throws MQTTProtocolException {
        RegionBroker regionBroker;
        ArrayList<PMQQueue> result = new ArrayList<PMQQueue>();
        try {
            regionBroker = (RegionBroker)this.brokerService.getBroker().getAdaptor(RegionBroker.class);
        }
        catch (Exception e) {
            throw new MQTTProtocolException("Error recovering queues: " + e.getMessage(), false, e);
        }
        QueueRegion queueRegion = (QueueRegion)regionBroker.getQueueRegion();
        for (PMQDestination destination : queueRegion.getDestinationMap().keySet()) {
            if (!destination.isQueue() || destination.isTemporary() || !destination.getPhysicalName().startsWith(VIRTUALTOPIC_CONSUMER_PREFIX + clientId + ":")) continue;
            LOG.debug("Recovered client sub: {} on connect", (Object)destination.getPhysicalName());
            result.add((PMQQueue)destination);
        }
        return result;
    }
}

