/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.stomp;

import com.primeton.pmq.broker.BrokerContext;
import com.primeton.pmq.broker.BrokerContextAware;
import com.primeton.pmq.command.DataStructure;
import com.primeton.pmq.command.PMQMapMessage;
import com.primeton.pmq.command.PMQMessage;
import com.primeton.pmq.command.PMQObjectMessage;
import com.primeton.pmq.transport.stomp.FrameTranslator;
import com.primeton.pmq.transport.stomp.LegacyFrameTranslator;
import com.primeton.pmq.transport.stomp.ProtocolConverter;
import com.primeton.pmq.transport.stomp.ProtocolException;
import com.primeton.pmq.transport.stomp.Stomp;
import com.primeton.pmq.transport.stomp.StompFrame;
import com.primeton.pmq.transport.stomp.XStreamSupport;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XppReader;
import com.thoughtworks.xstream.io.xml.xppdom.XppFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.jms.JMSException;
import org.codehaus.jettison.mapped.Configuration;
import org.fusesource.hawtbuf.UTF8Buffer;

public class JmsFrameTranslator
extends LegacyFrameTranslator
implements BrokerContextAware {
    XStream xStream = null;
    BrokerContext brokerContext;

    @Override
    public PMQMessage convertFrame(ProtocolConverter converter, StompFrame command) throws JMSException, ProtocolException {
        PMQMessage msg;
        Map<String, String> headers = command.getHeaders();
        String transformation = headers.get("transformation");
        if (headers.containsKey("content-length") || transformation.equals(Stomp.Transformations.JMS_BYTE.toString())) {
            msg = super.convertFrame(converter, command);
        } else {
            try {
                String text = new String(command.getContent(), "UTF-8");
                switch (Stomp.Transformations.getValue(transformation)) {
                    case JMS_OBJECT_XML: {
                        XppReader in = new XppReader((Reader)new StringReader(text), XppFactory.createDefaultParser());
                        msg = this.createObjectMessage((HierarchicalStreamReader)in);
                        break;
                    }
                    case JMS_OBJECT_JSON: {
                        HierarchicalStreamReader in = new JettisonMappedXmlDriver().createReader((Reader)new StringReader(text));
                        msg = this.createObjectMessage(in);
                        break;
                    }
                    case JMS_MAP_XML: {
                        XppReader in = new XppReader((Reader)new StringReader(text), XppFactory.createDefaultParser());
                        msg = this.createMapMessage((HierarchicalStreamReader)in);
                        break;
                    }
                    case JMS_MAP_JSON: {
                        HierarchicalStreamReader in = new JettisonMappedXmlDriver().createReader((Reader)new StringReader(text));
                        msg = this.createMapMessage(in);
                        break;
                    }
                    default: {
                        throw new Exception("Unknown transformation: " + transformation);
                    }
                }
            }
            catch (Throwable e) {
                command.getHeaders().put("transformation-error", e.getMessage());
                msg = super.convertFrame(converter, command);
            }
        }
        FrameTranslator.Helper.copyStandardHeadersFromFrameToMessage(converter, command, msg, this);
        return msg;
    }

    @Override
    public StompFrame convertMessage(ProtocolConverter converter, PMQMessage message) throws IOException, JMSException {
        StompFrame command = new StompFrame();
        command.setAction("MESSAGE");
        HashMap<String, String> headers = new HashMap<String, String>(25);
        command.setHeaders(headers);
        FrameTranslator.Helper.copyStandardHeadersFromMessageToFrame(converter, message, command, this);
        String transformation = (String)headers.get("transformation");
        if (message.getDataStructureType() == 26) {
            if (Stomp.Transformations.JMS_XML.equals(transformation)) {
                headers.put("transformation", Stomp.Transformations.JMS_OBJECT_XML.toString());
            } else if (Stomp.Transformations.JMS_JSON.equals(transformation)) {
                headers.put("transformation", Stomp.Transformations.JMS_OBJECT_JSON.toString());
            }
            if (!headers.containsKey("transformation")) {
                headers.put("transformation", Stomp.Transformations.JMS_OBJECT_XML.toString());
            }
            PMQObjectMessage msg = (PMQObjectMessage)message.copy();
            command.setContent(this.marshall(msg.getObject(), (String)headers.get("transformation")).getBytes("UTF-8"));
        } else if (message.getDataStructureType() == 25) {
            if (Stomp.Transformations.JMS_XML.equals(transformation)) {
                headers.put("transformation", Stomp.Transformations.JMS_MAP_XML.toString());
            } else if (Stomp.Transformations.JMS_JSON.equals(transformation)) {
                headers.put("transformation", Stomp.Transformations.JMS_MAP_JSON.toString());
            }
            if (!headers.containsKey("transformation")) {
                headers.put("transformation", Stomp.Transformations.JMS_MAP_XML.toString());
            }
            PMQMapMessage msg = (PMQMapMessage)message.copy();
            command.setContent(this.marshall((Serializable)((Object)msg.getContentMap()), (String)headers.get("transformation")).getBytes("UTF-8"));
        } else if (message.getDataStructureType() == 23 && "Advisory".equals(message.getType())) {
            if (Stomp.Transformations.JMS_XML.equals(transformation)) {
                headers.put("transformation", Stomp.Transformations.JMS_ADVISORY_XML.toString());
            } else if (Stomp.Transformations.JMS_JSON.equals(transformation)) {
                headers.put("transformation", Stomp.Transformations.JMS_ADVISORY_JSON.toString());
            }
            if (!headers.containsKey("transformation")) {
                headers.put("transformation", Stomp.Transformations.JMS_ADVISORY_JSON.toString());
            }
            String body = this.marshallAdvisory(message.getDataStructure(), (String)headers.get("transformation"));
            command.setContent(body.getBytes("UTF-8"));
        } else {
            command = super.convertMessage(converter, message);
        }
        return command;
    }

    protected String marshall(Serializable object, String transformation) throws JMSException {
        StringWriter buffer = new StringWriter();
        Object out = transformation.toLowerCase(Locale.ENGLISH).endsWith("json") ? new JettisonMappedXmlDriver(new Configuration(), false).createWriter((Writer)buffer) : new PrettyPrintWriter((Writer)buffer);
        this.getXStream().marshal((Object)object, (HierarchicalStreamWriter)out);
        return buffer.toString();
    }

    protected PMQObjectMessage createObjectMessage(HierarchicalStreamReader in) throws JMSException {
        PMQObjectMessage objMsg = new PMQObjectMessage();
        Object obj = this.getXStream().unmarshal(in);
        objMsg.setObject((Serializable)obj);
        return objMsg;
    }

    protected PMQMapMessage createMapMessage(HierarchicalStreamReader in) throws JMSException {
        PMQMapMessage mapMsg = new PMQMapMessage();
        Map map = (Map)this.getXStream().unmarshal(in);
        for (String key : map.keySet()) {
            mapMsg.setObject(key, map.get(key));
        }
        return mapMsg;
    }

    protected String marshallAdvisory(DataStructure ds, String transformation) {
        StringWriter buffer = new StringWriter();
        Object out = transformation.toLowerCase(Locale.ENGLISH).endsWith("json") ? new JettisonMappedXmlDriver().createWriter((Writer)buffer) : new PrettyPrintWriter((Writer)buffer);
        XStream xstream = this.getXStream();
        xstream.setMode(1001);
        xstream.aliasPackage("", "com.primeton.pmq.command");
        xstream.marshal((Object)ds, (HierarchicalStreamWriter)out);
        return buffer.toString();
    }

    public XStream getXStream() {
        if (this.xStream == null) {
            this.xStream = this.createXStream();
        }
        return this.xStream;
    }

    public void setXStream(XStream xStream) {
        this.xStream = xStream;
    }

    protected XStream createXStream() {
        XStream xstream = null;
        if (this.brokerContext != null) {
            Map beans = this.brokerContext.getBeansOfType(XStream.class);
            for (XStream bean : beans.values()) {
                if (bean == null) continue;
                xstream = bean;
                break;
            }
        }
        if (xstream == null) {
            xstream = XStreamSupport.createXStream();
            xstream.ignoreUnknownElements();
        }
        xstream.registerConverter((SingleValueConverter)new AbstractSingleValueConverter(){

            public Object fromString(String str) {
                return str;
            }

            public boolean canConvert(Class type) {
                return type.equals(UTF8Buffer.class);
            }
        });
        xstream.alias("string", UTF8Buffer.class);
        return xstream;
    }

    @Override
    public void setBrokerContext(BrokerContext brokerContext) {
        this.brokerContext = brokerContext;
    }

    @Override
    public BrokerContext getBrokerContext() {
        return this.brokerContext;
    }

    protected String marshallAdvisory(DataStructure ds) {
        XStream xstream = new XStream((HierarchicalStreamDriver)new JsonHierarchicalStreamDriver());
        xstream.setMode(1001);
        xstream.aliasPackage("", "com.primeton.pmq.command");
        return xstream.toXML((Object)ds);
    }
}

