/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.transport.stomp;

import com.primeton.pmq.transport.nio.NIOOutputStream;
import com.primeton.pmq.transport.nio.SelectorManager;
import com.primeton.pmq.transport.nio.SelectorSelection;
import com.primeton.pmq.transport.stomp.StompCodec;
import com.primeton.pmq.transport.tcp.TcpTransport;
import com.primeton.pmq.util.IOExceptionSupport;
import com.primeton.pmq.util.ServiceStopper;
import com.primeton.pmq.wireformat.WireFormat;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import javax.net.SocketFactory;

public class StompNIOTransport
extends TcpTransport {
    private SocketChannel channel;
    private SelectorSelection selection;
    private ByteBuffer inputBuffer;
    StompCodec codec;

    public StompNIOTransport(WireFormat wireFormat, SocketFactory socketFactory, URI remoteLocation, URI localLocation) throws UnknownHostException, IOException {
        super(wireFormat, socketFactory, remoteLocation, localLocation);
    }

    public StompNIOTransport(WireFormat wireFormat, Socket socket) throws IOException {
        super(wireFormat, socket);
    }

    public StompNIOTransport(WireFormat wireFormat, Socket socket, TcpTransport.InitBuffer initBuffer) throws IOException {
        super(wireFormat, socket, initBuffer);
    }

    @Override
    protected void initializeStreams() throws IOException {
        this.channel = this.socket.getChannel();
        this.channel.configureBlocking(false);
        this.selection = SelectorManager.getInstance().register(this.channel, new SelectorManager.Listener(){

            @Override
            public void onSelect(SelectorSelection selection) {
                StompNIOTransport.this.serviceRead();
            }

            @Override
            public void onError(SelectorSelection selection, Throwable error) {
                if (error instanceof IOException) {
                    StompNIOTransport.this.onException((IOException)error);
                } else {
                    StompNIOTransport.this.onException(IOExceptionSupport.create(error));
                }
            }
        });
        this.inputBuffer = ByteBuffer.allocate(8192);
        NIOOutputStream outPutStream = new NIOOutputStream(this.channel, 8192);
        this.dataOut = new DataOutputStream(outPutStream);
        this.buffOut = outPutStream;
        this.codec = new StompCodec(this);
        try {
            if (this.initBuffer != null) {
                this.processBuffer(this.initBuffer.buffer, this.initBuffer.readSize);
            }
        }
        catch (IOException e) {
            this.onException(e);
        }
        catch (Throwable e) {
            this.onException(IOExceptionSupport.create(e));
        }
    }

    private void serviceRead() {
        try {
            while (true) {
                int readSize;
                if ((readSize = this.channel.read(this.inputBuffer)) == -1) {
                    this.onException(new EOFException());
                    this.selection.close();
                } else if (readSize != 0) {
                    this.processBuffer(this.inputBuffer, readSize);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            this.onException(e);
        }
        catch (Throwable e) {
            this.onException(IOExceptionSupport.create(e));
        }
    }

    protected void processBuffer(ByteBuffer buffer, int readSize) throws Exception {
        this.receiveCounter += readSize;
        buffer.flip();
        ByteArrayInputStream input = new ByteArrayInputStream(buffer.array());
        this.codec.parse(input, readSize);
        buffer.clear();
    }

    @Override
    protected void doStart() throws Exception {
        this.connect();
        this.selection.setInterestOps(1);
        this.selection.enable();
    }

    @Override
    protected void doStop(ServiceStopper stopper) throws Exception {
        try {
            if (this.selection != null) {
                this.selection.close();
            }
        }
        finally {
            super.doStop(stopper);
        }
    }
}

