/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.util;

import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.util.URISupport;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

public class StringToListOfPMQDestinationConverter {
    public static List<PMQDestination> convertToPMQDestination(Object value) {
        if (value == null) {
            return null;
        }
        String text = value.toString();
        if (text.startsWith("[") && text.endsWith("]")) {
            if ((text = text.substring(1, text.length() - 1).trim()).isEmpty()) {
                return null;
            }
            String[] array = text.split(",");
            ArrayList<PMQDestination> list = new ArrayList<PMQDestination>();
            for (String item : array) {
                list.add(PMQDestination.createDestination(item.trim(), (byte)1));
            }
            return list;
        }
        return null;
    }

    public static String convertFromPMQDestination(Object value) {
        return StringToListOfPMQDestinationConverter.convertFromPMQDestination(value, false);
    }

    public static String convertFromPMQDestination(Object value, boolean includeOptions) {
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("[");
        if (value instanceof List) {
            List list = (List)value;
            for (int i = 0; i < list.size(); ++i) {
                Object e = list.get(i);
                if (!(e instanceof PMQDestination)) continue;
                PMQDestination destination = (PMQDestination)e;
                if (includeOptions && destination.getOptions() != null) {
                    try {
                        sb.append(destination.toString() + URISupport.applyParameters(new URI(""), destination.getOptions()));
                    }
                    catch (URISyntaxException e1) {
                        sb.append(destination);
                    }
                } else {
                    sb.append(destination);
                }
                if (i >= list.size() - 1) continue;
                sb.append(", ");
            }
        }
        sb.append("]");
        if (sb.length() > 2) {
            return sb.toString();
        }
        return null;
    }
}

