/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.xbean;

import com.primeton.pmq.broker.BrokerFactory;
import com.primeton.pmq.broker.BrokerService;
import com.primeton.pmq.usage.SystemUsage;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.CachedIntrospectionResults;

public class XBeanBrokerService
extends BrokerService {
    private boolean start = BrokerFactory.getStartDefault();

    @PostConstruct
    private void postConstruct() {
        try {
            this.afterPropertiesSet();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.ensureSystemUsageHasStore();
        if (this.shouldAutostart()) {
            this.start();
        }
    }

    @Override
    protected boolean shouldAutostart() {
        return this.start;
    }

    private void ensureSystemUsageHasStore() throws IOException {
        SystemUsage usage = this.getSystemUsage();
        if (usage.getStoreUsage().getStore() == null) {
            usage.getStoreUsage().setStore(this.getPersistenceAdapter());
        }
        if (usage.getTempUsage().getStore() == null) {
            usage.getTempUsage().setStore(this.getTempDataStore());
        }
        if (usage.getJobSchedulerUsage().getStore() == null) {
            usage.getJobSchedulerUsage().setStore(this.getJobSchedulerStore());
        }
    }

    @PreDestroy
    private void preDestroy() {
        try {
            this.destroy();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void destroy() throws Exception {
        this.stop();
    }

    @Override
    public void stop() throws Exception {
        CachedIntrospectionResults.clearClassLoader(this.getClass().getClassLoader());
        super.stop();
    }

    public void setStart(boolean start2) {
        this.start = start2;
    }
}

