package com.primeton.esb.httpToJms.httpToJms;

import java.util.HashMap;
import com.primeton.esb.message.ITipMessagePayload;
import com.primeton.esb.message.MessageConstants;
import com.primeton.esb.message.TipMessageBuilder;

public class ConvertProtocol {	
    private static String httpReplyText ="<soapenv:Envelope xmlns:soapenv=\"http://www.w3.org/2003/05/soap-envelope\">"
        +"<soapenv:Body>"
        +"    <ns:sayHiResponse xmlns:ns=\"http://quickstart.helloworld/xsd\">"
            +"      <ns:return>Hello Primeton ESB!</ns:return>"
            +"    </ns:sayHiResponse>"
            +" </soapenv:Body>"
            +"</soapenv:Envelope>";

  /**
   * 根据HTTP请求消息构建JMS消息的消息体
   *
   * @param httpRequestMsg
   * @return
   * @throws Exception
   */
  public static ITipMessagePayload doHttpToJms(
                   ITipMessagePayload httpRequestMsg) throws Exception {

          String requestText = (String) httpRequestMsg.getMessagePayload();
          //根据messagePayload构建TipMessageBuilder
          TipMessageBuilder builder = TipMessageBuilder.withPayload(requestText);
          //定义消息头
          HashMap<String, Object> messageHeaders = new HashMap<String, Object>();
          //设置系统头-消息传递方向为单向消息
          builder.setSystemHeader(MessageConstants.MESSAGE_INVOKE_TYPE,
                            MessageConstants.ONE_WAY);
          //设置消息头
          builder.setMessageHeaders(messageHeaders);
          //构建出JMS请求消息
          return  builder.build();
  }

  /**
   * 自定义返回HTTP响应消息
   *
   * @param httpRequestMsg
   * @return
   * @throws Exception
   */
  public static ITipMessagePayload createHttpReply(ITipMessagePayload httpRequestMsg)
                   throws Exception {
          String replyText = httpReplyText;
          //根据messagePayload构建TipMessageBuilder
          TipMessageBuilder builder = TipMessageBuilder.withPayload(replyText);
          //根据HTTP请求消息得到系统头
          builder.copySystemHeaders(httpRequestMsg.getSystemHeaders());
          //根据HTTP请求消息得到协议头
          builder.setProtocolHeaders(httpRequestMsg.getProtocolHeaders());
          //构建出HTTP响应消息
          return builder.build();
  }


}

