/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.example.engine;

import cn.hutool.core.util.StrUtil;
import com.google.auto.service.AutoService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.transform.sql.zeta.ZetaUDF;

@AutoService(value={ZetaUDF.class})
public class QdmxUDF
implements ZetaUDF {
    public String functionName() {
        return "QDMX";
    }

    public SeaTunnelDataType<?> resultType(List<SeaTunnelDataType<?>> list) {
        return BasicType.STRING_TYPE;
    }

    public Object evaluate(List<Object> list) {
        String str = list.get(0).toString();
        str = StrUtil.replace((CharSequence)str, (CharSequence)"SeaTunnelRow{tableId=, kind=+I, fields=[{", (CharSequence)"");
        Map<String, String> map = QdmxUDF.parseToMap(str = StrUtil.sub((CharSequence)str, (int)-1, (int)0));
        if ("null".equals(map.get(list.get(1).toString()))) {
            return "";
        }
        return map.get(list.get(1).toString());
    }

    public static Map<String, String> parseToMap(String input) {
        String[] pairs;
        HashMap<String, String> map = new HashMap<String, String>();
        input = input.replaceAll("[{}]", "");
        for (String pair : pairs = input.split(", ")) {
            String[] keyValue = pair.split("=");
            if (keyValue.length != 2) continue;
            String key = keyValue[0].trim();
            String value = keyValue[1].trim();
            map.put(key, value);
        }
        return map;
    }
}

