DROP TABLE IF EXISTS BFP_PROCESS_OPINIONS;
CREATE TABLE BFP_PROCESS_OPINIONS (
  OPINION_ID VARCHAR(64) NOT NULL PRIMARY KEY,
  OPINION_CONTENT VARCHAR(1024),
  OPINION_STATUS VARCHAR(32),
  PROCESS_INST_ID DECIMAL(20,0),
  WORK_ITEM_ID VARCHAR(64),
  ACTIVITY_INST_ID VARCHAR(64),
  ACTIVITY_INST_NAME VARCHAR(512),
  ACTIVITY_DEF_ID VARCHAR(128),
  CREATE_USER_ID VARCHAR(64),
  CREATE_USER_NAME VARCHAR(64),
  CREATE_TIME DATE,
  HANDLE_TIME DATE,
  HANDLE_DURATION VARCHAR(64),
  CREATE_ORG_ID VARCHAR(64),
  CREATE_ORG_NAME VARCHAR(128),
  ATTACHMENT_ID VARCHAR(128),
  TENANT_ID VARCHAR(128),
  EXTEND1 VARCHAR(256),
  EXTEND2 VARCHAR(256),
  EXTEND3 VARCHAR(256)
);

DROP TABLE IF EXISTS BFP_PROCESS_BIZ_RELATION;
CREATE TABLE BFP_PROCESS_BIZ_RELATION (
  RELATION_ID VARCHAR(64) not null PRIMARY KEY,
  BIZ_PRIMARY_KEY_ID VARCHAR(256),
  BIZ_PRIMARY_KEY_VALUE VARCHAR(4000),
  PROCESS_INST_ID DECIMAL(20,0),
  PROCESS_DEF_ID DECIMAL(20,0),
  PROCESS_DEF_NAME VARCHAR(256),
  PROCESS_CH_NAME VARCHAR(256),
  PROCESS_VERSION VARCHAR(8),
  PROCESS_INST_NAME VARCHAR(256),
  CATALOG_UUID VARCHAR(32),
  WORK_ITEM_ID DECIMAL(20,0)
);

-- 2022-12-13 关系表中添加ENTITY_NAME。支持多实体
ALTER TABLE BFP_PROCESS_BIZ_RELATION ADD ENTITY_NAME    VARCHAR(256);

DROP TABLE IF EXISTS BFP_PROCESS_COMMON;
CREATE TABLE BFP_PROCESS_COMMON (
    COMMON_ID VARCHAR(64) NOT NULL PRIMARY KEY,
    USER_NAME VARCHAR(64),
    COMMON_INFO VARCHAR(1024),
    PROCESS_DEF_NAME VARCHAR(64)
);

ALTER TABLE BFP_PROCESS_COMMON ADD COMMON_TYPE VARCHAR(64);