
DROP TABLE IF EXISTS BFP_PROCESS_OPINIONS;
CREATE TABLE BFP_PROCESS_OPINIONS (
    OPINION_ID VARCHAR(64) NOT NULL COMMENT '主键',
    OPINION_CONTENT VARCHAR(1024) COMMENT '审批内容',
    OPINION_STATUS VARCHAR(32) COMMENT '审批状态',
    PROCESS_INST_ID BIGINT(20) COMMENT '流程实例id',
    WORK_ITEM_ID VARCHAR(64) COMMENT '工作项id',
    ACTIVITY_INST_ID VARCHAR(64) COMMENT '活动实例id',
    ACTIVITY_INST_NAME VARCHAR(512) COMMENT '活动实例名',
    ACTIVITY_DEF_ID VARCHAR(128) COMMENT '活动定义id',
    CREATE_USER_ID VARCHAR(64) COMMENT '当前用户',
    CREATE_USER_NAME VARCHAR(64) COMMENT '当前用户名',
    CREATE_TIME DATETIME COMMENT '创建时间',
    HANDLE_TIME DATETIME COMMENT '处理时间',
    HANDLE_DURATION VARCHAR(64) COMMENT '处理时长',
    CREATE_ORG_ID VARCHAR(64) COMMENT '当前机构',
    CREATE_ORG_NAME VARCHAR(128) COMMENT '当前机构名',
    ATTACHMENT_ID VARCHAR(128) COMMENT '附件id',
    TENANT_ID VARCHAR(128) COMMENT '租户id',
    EXTEND1 VARCHAR(256) COMMENT '扩展字段1',
    EXTEND2 VARCHAR(256) COMMENT '扩展字段2',
    EXTEND3 VARCHAR(256) COMMENT '扩展字段3',
    PRIMARY KEY (OPINION_ID)
) COMMENT = '审批意见表';

DROP TABLE IF EXISTS BFP_PROCESS_BIZ_RELATION;
CREATE TABLE BFP_PROCESS_BIZ_RELATION (
	RELATION_ID varchar(64) not null  COMMENT '主键',
	BIZ_PRIMARY_KEY_ID varchar(256) COMMENT '关联业务表主键名',
	BIZ_PRIMARY_KEY_VALUE varchar(4000) COMMENT '关联业务表主键id',
	PROCESS_INST_ID BIGINT(20) COMMENT '流程实例id',
	PROCESS_DEF_ID BIGINT(20) COMMENT '流程定义id',
	PROCESS_DEF_NAME varchar(256) COMMENT '流程定义名',
	PROCESS_CH_NAME varchar(256) COMMENT '流程显示名',
	PROCESS_VERSION varchar(8) COMMENT '流程版本',
	PROCESS_INST_NAME varchar(256) COMMENT '流程实例名',
	CATALOG_UUID VARCHAR(32) COMMENT '业务目录id',
	WORK_ITEM_ID BIGINT(20) COMMENT '工作项id',
	primary key (RELATION_ID)
	/*UNIQUE KEY `PROCESS_BIZ` (`BIZ_PRIMARY_KEY_ID`, `BIZ_PRIMARY_KEY_VALUE`, `PROCESS_INST_ID`, `PROCESS_DEF_ID`)*/
) COMMENT = '业务流程关系表';

-- 2022-12-13 关系表中添加ENTITY_NAME。支持多实体
ALTER TABLE BFP_PROCESS_BIZ_RELATION ADD COLUMN ENTITY_NAME varchar(256) COMMENT '实体名称';


DROP TABLE IF EXISTS BFP_PROCESS_COMMON;
CREATE TABLE BFP_PROCESS_COMMON (
    COMMON_ID varchar(64) NOT NULL COMMENT '常用语主键',
    USER_NAME varchar(64) DEFAULT NULL COMMENT '用户账号',
    COMMON_INFO varchar(1024) DEFAULT NULL COMMENT '常用语信息',
    PROCESS_DEF_NAME varchar(64) DEFAULT NULL COMMENT '流程定义名称',
    PRIMARY KEY (COMMON_ID)
) COMMENT = '审批常用语信息表';

-- 2023-05-10 审批常用语信息表中添加COMMON_TYPE
ALTER TABLE BFP_PROCESS_COMMON ADD COLUMN COMMON_TYPE varchar(64) COMMENT '常用语类型（system-系统，personal-个人,process-流程）';