
CREATE TABLE BFP_PROCESS_OPINIONS (
  OPINION_ID         VARCHAR2(64) NOT NULL,
  OPINION_CONTENT    VARCHAR2(1024),
  OPINION_STATUS     VARCHAR2(32),
  PROCESS_INST_ID    NUMBER,
  WORK_ITEM_ID       VARCHAR2(64),
  ACTIVITY_INST_ID   VARCHAR2(64),
  ACTIVITY_INST_NAME VARCHAR2(512),
  ACTIVITY_DEF_ID    VARCHAR2(128),
  CREATE_USER_ID     VARCHAR2(64),
  CREATE_USER_NAME   VARCHAR2(64),
  CREATE_TIME        VARCHAR2(64),
  HANDLE_TIME        VARCHAR2(64),
  HANDLE_DURATION    VARCHAR2(64),
  CREATE_ORG_ID      VARCHAR2(64),
  CREATE_ORG_NAME    VARCHAR2(128),
  ATTACHMENT_ID      VARCHAR2(128),
  TENANT_ID          VARCHAR2(128),
  EXTEND1            VARCHAR2(256),
  EXTEND2            VARCHAR2(256),
  EXTEND3            VARCHAR2(256),
  PRIMARY KEY (OPINION_ID)
);

CREATE TABLE BFP_PROCESS_BIZ_RELATION (
	RELATION_ID VARCHAR2(64) NOT NULL,
	BIZ_PRIMARY_KEY_ID VARCHAR2(256),
	BIZ_PRIMARY_KEY_VALUE VARCHAR2(4000),
	PROCESS_INST_ID NUMBER(12),
	PROCESS_DEF_ID NUMBER(12),
	PROCESS_DEF_NAME VARCHAR2(256),
	PROCESS_CH_NAME VARCHAR2(256),
	PROCESS_VERSION VARCHAR2(8),
	PROCESS_INST_NAME VARCHAR2(256),
	CATALOG_UUID VARCHAR2(32),
	WORK_ITEM_ID NUMBER(12),
	PRIMARY KEY (RELATION_ID)
);

-- 2022-12-13 关系表中添加ENTITY_NAME。支持多实体
ALTER TABLE BFP_PROCESS_BIZ_RELATION ADD ENTITY_NAME    VARCHAR2(256);

CREATE TABLE BFP_PROCESS_COMMON (
    COMMON_ID VARCHAR2(64) NOT NULL,
    USER_NAME VARCHAR2(64),
    COMMON_INFO VARCHAR2(1024),
    PROCESS_DEF_NAME VARCHAR2(64),
    PRIMARY KEY (COMMON_ID)
);

ALTER TABLE BFP_PROCESS_COMMON ADD COMMON_TYPE VARCHAR2(64);