IF OBJECT_ID('BFP_PROCESS_OPINIONS') IS NOT NULL
DROP TABLE BFP_PROCESS_OPINIONS;
CREATE TABLE BFP_PROCESS_OPINIONS
(
    OPINION_ID         NVARCHAR(64) NOT NULL PRIMARY KEY,
    OPINION_CONTENT    NVARCHAR(1024),
    OPINION_STATUS     NVARCHAR(32),
    PROCESS_INST_ID    BIGINT,
    WORK_ITEM_ID       NVARCHAR(64),
    ACTIVITY_INST_ID   NVARCHAR(64),
    ACTIVITY_INST_NAME NVARCHAR(512),
    ACTIVITY_DEF_ID    NVARCHAR(128),
    CREATE_USER_ID     NVARCHAR(64),
    CREATE_USER_NAME   NVARCHAR(64),
    CREATE_TIME        DATETIME2,
    HANDLE_TIME        DATETIME2,
    HANDLE_DURATION    NVARCHAR(64),
    CREATE_ORG_ID      NVARCHAR(64),
    CREATE_ORG_NAME    NVARCHAR(128),
    ATTACHMENT_ID      NVARCHAR(128),
    TENANT_ID          NVARCHAR(128),
    EXTEND1            NVARCHAR(256),
    EXTEND2            NVARCHAR(256),
    EXTEND3            NVARCHAR(256)
);

IF OBJECT_ID('BFP_PROCESS_BIZ_RELATION') IS NOT NULL
DROP TABLE BFP_PROCESS_BIZ_RELATION;
CREATE TABLE BFP_PROCESS_BIZ_RELATION
(
    RELATION_ID           NVARCHAR(64) not null PRIMARY KEY,
    BIZ_PRIMARY_KEY_ID    NVARCHAR(256),
    BIZ_PRIMARY_KEY_VALUE NVARCHAR(4000),
    PROCESS_INST_ID       BIGINT,
    PROCESS_DEF_ID        BIGINT,
    PROCESS_DEF_NAME      NVARCHAR(256),
    PROCESS_CH_NAME       NVARCHAR(256),
    PROCESS_VERSION       NVARCHAR(8),
    PROCESS_INST_NAME     NVARCHAR(256),
    CATALOG_UUID          NVARCHAR(32),
    WORK_ITEM_ID          BIGINT
);
-- 2022-12-13 关系表中添加ENTITY_NAME。支持多实体
ALTER TABLE BFP_PROCESS_BIZ_RELATION ADD ENTITY_NAME NVARCHAR(256);

IF OBJECT_ID('BFP_PROCESS_COMMON') IS NOT NULL
DROP TABLE BFP_PROCESS_COMMON;
CREATE TABLE BFP_PROCESS_COMMON (
    COMMON_ID NVARCHAR(64) NOT NULL,
    USER_NAME NVARCHAR(64),
    COMMON_INFO NVARCHAR(1024),
    PROCESS_DEF_NAME NVARCHAR(64),
    PRIMARY KEY (COMMON_ID)
);

ALTER TABLE BFP_PROCESS_COMMON ADD COMMON_TYPE NVARCHAR(64);