@echo off

set PRG=%~dp0

set EOS_DAP_HOME=%PRG:~0,-5%
set PRIMETON_HOME=%PRG:~0,-14%


if not exist "%JAVA_HOME%\bin\java.exe"  set JAVA_HOME=%PRIMETON_HOME%\jdk180

set "JAVA=%JAVA_HOME%\bin\java.exe"

set APP_NAME=EOS8-DEMO-APP
set LOG_FOLDER=%EOS_DAP_HOME%/logs

set EOS_DAP_MEM_OPTS=-Xms512m -Xmx1024m -Xmn256m

set JAVA_OPTS=%JAVA_OPTS% -Djava.net.preferIPv4Stack=true -Duser.timezone=Asia/Shanghai -Dclient.encoding.override=UTF-8 -Dfile.encoding=UTF-8
set JAVA_OPTS=%JAVA_OPTS% %EOS_DAP_MEM_OPTS%
set JAVA_OPTS=%JAVA_OPTS% -DEXTERNAL_CONFIG_DIR=%EOS_DAP_HOME%\config
set JAVA_OPTS=%JAVA_OPTS% -Dloader.path=%EOS_DAP_HOME%\lib 
set JAVA_OPTS=%JAVA_OPTS% -Dlogging.config=%EOS_DAP_HOME%\config\logback-spring.xml
set JAVA_OPTS=%JAVA_OPTS% -Dnacos.logging.path=%LOG_FOLDER%\nacos -Dcom.alibaba.nacos.naming.cache.dir=%LOG_FOLDER%\nacos\cache

@rem set JAVA_OPTS=%JAVA_OPTS% -XX:+UseParNewGC -XX:ParallelGCThreads=4 -XX:MaxTenuringThreshold=9 -XX:+UseConcMarkSweepGC

echo %*| findstr \-debug >nul && (
    set JAVA_OPTS=%JAVA_OPTS% -XX:+HeapDumpOnOutOfMemoryError -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=8787
)

echo %*| findstr \-apm >nul && (
    set JAVA_OPTS=%JAVA_OPTS% -javaagent:%EOS_DAP_HOME%\..\..\skywalking-agent\skywalking-agent.jar
    set JAVA_OPTS=%JAVA_OPTS% -DSW_AGENT_NAME=%APP_NAME%
    set JAVA_OPTS=%JAVA_OPTS% -Dskywalking.trace.ignore_path=/eureka/**,/actuator/eos/**,/nacos/**
    @rem set JAVA_OPTS=%JAVA_OPTS% -DSW_AGENT_COLLECTOR_BACKEND_SERVICES=127.0.0.1:11800
)

echo %*| findstr \-version >nul && (
    set JAVA_OPTS=%JAVA_OPTS% -Dloader.main=com.primeton.eos.springboot.VersionInfo
)

set JAVA_OPTS=%JAVA_OPTS% %FORCE_JAVA_OPTS%

echo %*| findstr \-opens >nul && (
    set JAVA_OPTS=%JAVA_OPTS% --add-opens java.base/java.lang=ALL-UNNAMED
)

cd %EOS_DAP_HOME%

FOR /F %%i IN ('dir /b *.jar') DO @set JAR_FILE=%%i
set BOOT_JAR=%EOS_DAP_HOME%\%JAR_FILE%

title %JAR_FILE%
"%JAVA%" %JAVA_OPTS% -jar %BOOT_JAR% %1 %2 %3 
