
/*==============================================================*/
/* Table: LC_CONTRIBUTION                                   */
/*==============================================================*/
DROP TABLE IF EXISTS LC_CONTRIBUTION;
CREATE TABLE LC_CONTRIBUTION  (
  ID                         VARCHAR(64)        NOT NULL     COMMENT 'ID',
  CODE                       VARCHAR(256)                    COMMENT '编码',
  NAME                       VARCHAR(256)                     COMMENT '名称',
  CATEGORY                   VARCHAR(64)                     COMMENT '构件包种类，在线还是离线',
  APP_NAME   			     VARCHAR(64)                     COMMENT '应用名称',
  DESCRIPTION                TEXT                            COMMENT '描述',
  EXTEND                     TEXT                            COMMENT '扩展信息',
  DEL_FLAG                   CHAR                            COMMENT '删除标志',
  CREATE_USER                VARCHAR(64)                     COMMENT '创建人',
  CREATE_TIME                DATETIME                        COMMENT '创建时间',
  UPDATE_USER                VARCHAR(64)                     COMMENT '更新人',
  UPDATE_TIME                DATETIME                        COMMENT '更新时间',
  TENANT_ID                  VARCHAR(64)                     COMMENT '租户ID',
  ONLINE_TYPE                VARCHAR(64)                     COMMENT '在线构件包类型:通用、报表等', 
  BI_FOLDER                  VARCHAR(64)                     COMMENT '映射BI目录', 
  PRIMARY KEY (ID)
) COMMENT='低开构件包表';

/*==============================================================*/
/* Table: LC_RESOURCE                                       */
/*==============================================================*/
DROP TABLE IF EXISTS LC_RESOURCE;
CREATE TABLE LC_RESOURCE  (
  ID                         VARCHAR(64)        NOT NULL     COMMENT 'ID',
  CODE                       VARCHAR(256)                    COMMENT '编码，数据集时是namespace',
  NAME                       VARCHAR(256)                     COMMENT '名称',
  RESOURCE_TYPE              VARCHAR(64)                     COMMENT '资源类型',
  CONTRIBUTION_ID			 VARCHAR(64)                     COMMENT '所属构件包ID',
  APP_NAME                   VARCHAR(64)                     COMMENT '应用名称',
  DESCRIPTION                TEXT                            COMMENT '描述',
  MD5                        VARCHAR(512)                    COMMENT '内容摘要',
  RUNTIME_MD5                VARCHAR(512)                    COMMENT '生效的运行时资源内容摘要',
  FILE_PATH                  VARCHAR(512)                    COMMENT '文件路径',
  STATUS                     VARCHAR(64)                     COMMENT '状态',
  CHANGE_VERSION             INTEGER                         COMMENT '变更版本',
  EXTEND                     TEXT                            COMMENT '扩展信息',
  DEL_FLAG                   CHAR                            COMMENT '删除标志',
  CREATE_USER                VARCHAR(64)                     COMMENT '创建人',
  CREATE_TIME                DATETIME                        COMMENT '创建时间',
  UPDATE_USER                VARCHAR(64)                     COMMENT '更新人',
  UPDATE_TIME                DATETIME                        COMMENT '更新时间',
  TENANT_ID                  VARCHAR(64)                     COMMENT '租户ID',
  CATEGORY1                  VARCHAR(256)                    COMMENT '资源类型1',
  CATEGORY2                  VARCHAR(256)                    COMMENT '资源类型2',
  CATEGORY3                  VARCHAR(256)                    COMMENT '资源类型3',
  BI_RESOURCE                VARCHAR(256)                    COMMENT '映射BI资源路径',
  RESOURCE_SUB_TYPE          VARCHAR(256)                    COMMENT '资源二级类型',
  RESOURCE_GROUP_ID          VARCHAR(64)                     COMMENT '资源分组ID',
  PRIMARY KEY (ID)
) COMMENT='低开资源表';

/*==============================================================*/
/* Table: LC_RESOURCE_CONTENT                               */
/*==============================================================*/
DROP TABLE IF EXISTS LC_RESOURCE_CONTENT;
CREATE TABLE LC_RESOURCE_CONTENT  (
  ID                         VARCHAR(64)        NOT NULL     COMMENT 'ID',
  CONTRIBUTION_ID			       VARCHAR(64)                     COMMENT '所属构件包ID',
  CONTENT                    LONGTEXT                        COMMENT '内容',
  ENCODING                   VARCHAR(64)                     COMMENT '编码',
  BIN_CONTENT                LONGBLOB                        COMMENT '二进制文件内容',
  EXTEND                     TEXT                            COMMENT '扩展信息',
  PRIMARY KEY (ID)
) COMMENT='低开资源内容表';

/*==============================================================*/
/* Table: LC_H_RESOURCE_CONTENT                               */
/*==============================================================*/
DROP TABLE IF EXISTS LC_H_RESOURCE_CONTENT;
CREATE TABLE LC_H_RESOURCE_CONTENT  (
  ID                         VARCHAR(64)        NOT NULL     COMMENT 'ID',
  RESOURCE_ID    	      	 VARCHAR(64)                     COMMENT '所属资源ID',
  CONTRIBUTION_ID			 VARCHAR(64)                     COMMENT '所属构件包ID',
  MD5                        VARCHAR(512)                    COMMENT '内容摘要',
  CONTENT                    LONGTEXT                        COMMENT '内容',
  ENCODING                   VARCHAR(64)                     COMMENT '编码',
  BIN_CONTENT                LONGBLOB                        COMMENT '二进制文件内容',
  COMMIT_VERSION             VARCHAR(64)                     COMMENT '提交版本',
  COMMIT_MESSAGE             VARCHAR(512)                    COMMENT '提交信息',
  UPDATE_USER                VARCHAR(64)                     COMMENT '更新人',
  UPDATE_TIME                DATETIME                        COMMENT '更新时间',
  EXTEND                     TEXT                            COMMENT '扩展信息',
  PRIMARY KEY (ID)
) COMMENT='低开资源内容历史表';

/*==============================================================*/
/* Table: LC_RUNTIME_RESOURCE                               */
/*==============================================================*/
DROP TABLE IF EXISTS LC_RUNTIME_RESOURCE;
CREATE TABLE LC_RUNTIME_RESOURCE  (
  ID                         VARCHAR(64)        NOT NULL     COMMENT 'ID',
  RESOURCE_ID    	      	 VARCHAR(64)                     COMMENT '所属资源ID',
  CONTRIBUTION_ID			 VARCHAR(64)                     COMMENT '所属构件包ID',
  SOURCE_MD5                 VARCHAR(512)                    COMMENT '源资源内容摘要',
  FILE_PATH                  VARCHAR(512)                    COMMENT '文件路径',
  CONTENT                    LONGTEXT                        COMMENT '内容',
  ENCODING                   VARCHAR(64)                     COMMENT '编码',
  BIN_CONTENT                LONGBLOB                        COMMENT '二进制文件内容',
  CREATE_USER                VARCHAR(64)                     COMMENT '创建人',
  CREATE_TIME                DATETIME                        COMMENT '创建时间',
  UPDATE_USER                VARCHAR(64)                     COMMENT '更新人',
  UPDATE_TIME                DATETIME                        COMMENT '更新时间',
  PRIMARY KEY (ID)
) COMMENT='低开运行时（编译后）资源表';

/*==============================================================*/
/* Table: LC_R_ENTITY_DATASOURCE                                   */
/*==============================================================*/
drop table if exists LC_R_ENTITY_DATASOURCE;
create table LC_R_ENTITY_DATASOURCE
(
   APP_NAME              varchar(64) not null comment '应用名称',
   DATASOURCE_NAME       varchar(64) not null comment '数据源名称',
   ENTITY_NAME_INCLUDES  varchar(512) comment '包含的实体名称，多个逗号分隔，支持统配',
   ENTITY_NAME_EXCLUDES  varchar(512) comment '排除的实体名称，多个逗号分隔，支持统配',
   primary key(APP_NAME, DATASOURCE_NAME)
) comment='数据实体和数据源的关联关系表';

/*==============================================================*/
/* Table: LC_PROJECT_BASELINE                                   */
/*==============================================================*/
DROP TABLE IF EXISTS LC_PROJECT_BASELINE;
CREATE TABLE LC_PROJECT_BASELINE  (
  ID                        VARCHAR(64)           NOT NULL      COMMENT 'ID',
  NAME                      VARCHAR(256)                        COMMENT '基线名称',
  CODE                      VARCHAR(256)                        COMMENT '基线标识(版本+名称)',
  TAG_NUM                   VARCHAR(64)                         COMMENT '基线版本',
  APP_NAME                  VARCHAR(64)                         COMMENT '应用名称',
  IS_USE                    INT(1)                              COMMENT '是否当前使用基线 0：否 1：是',
  RESOURCE_BASELINE_DATA    LONGTEXT                            COMMENT '当前基线资源源码',
  DESCRIPTION               TEXT                                COMMENT '描述',
  CREATE_USER               VARCHAR(64)                         COMMENT '创建人',
  CREATE_TIME               DATETIME                            COMMENT '创建时间',
  UPDATE_USER               VARCHAR(64)                         COMMENT '修改人',
  UPDATE_TIME               DATETIME                            COMMENT '修改时间',
  TENANT_ID                 VARCHAR(64)                         COMMENT '租户ID',
  PRIMARY KEY (ID)
) COMMENT = '低开项目基线表';

/*==============================================================*/
/* Table: LC_PROJECT_SNAPSHOT                                   */
/*==============================================================*/
DROP TABLE IF EXISTS LC_PROJECT_SNAPSHOT;
CREATE TABLE LC_PROJECT_SNAPSHOT  (
  APP_NAME                  VARCHAR(64)           NOT NULL      COMMENT '应用名称',
  CONTENT                   LONGTEXT                            COMMENT '项目当前快照',
  PRIMARY KEY (APP_NAME)
) COMMENT = '项目当前快照表';

DROP TABLE IF EXISTS LC_R_RESOURCE_RELATION;
CREATE TABLE LC_R_RESOURCE_RELATION  (
  ID                          VARCHAR(64)       NOT NULL    COMMENT 'ID',
  SOURCE_CODE                 VARCHAR(512)                  COMMENT '源模型编码',
  SOURCE_SUB_ID               VARCHAR(512)                  COMMENT '源模型次级标识(主要给实体用)',
  SOURCE_TYPE                 VARCHAR(64)                   COMMENT '源模型类型',
  SOURCE_CATEGORY             VARCHAR(64)                   COMMENT '源资源种类：在线还是离线',
  TARGET_CODE                 VARCHAR(512)                  COMMENT '目标模型qname(离线资源)',
  TARGET_SUB_ID               VARCHAR(512)                  COMMENT '目标模型次级标识',
  TARGET_TYPE                 VARCHAR(64)                   COMMENT '目标模型类型',
  TARGET_CATEGORY             VARCHAR(64)                   COMMENT '目标源种类：在线还是离线',
  APP_NAME                    VARCHAR(64)                   COMMENT '应用名称',
  PRIMARY KEY (ID)
) COMMENT = '资源关系表';

DROP TABLE IF EXISTS LC_R_BI_DATASOURCE_RELATION;
CREATE TABLE LC_R_BI_DATASOURCE_RELATION
(
    ID                       VARCHAR(64)        NOT NULL 	   COMMENT '主键',
    APP_NAME                 VARCHAR(64)        NOT NULL 	   COMMENT '应用名称',
    DATASOURCE_ID            VARCHAR(64)        NOT NULL 	   COMMENT '分析数据源ID',
    DATASOURCE_NAME          VARCHAR(256)       NOT NULL       COMMENT '分析数据源名称',
    PRIMARY KEY (ID)
)COMMENT='分析数据源关系表' CHARSET=UTF8;

DROP TABLE IF EXISTS LC_IMPORT_HISTORY;
CREATE TABLE LC_IMPORT_HISTORY  (
  ID                          varchar(64)       NOT NULL        COMMENT '主键',
  IMPORT_BASELINE_NAME        varchar(256)                      COMMENT '导入基线名称',
  IMPORT_BASELINE_NUM         varchar(64)                       COMMENT '导入基线版本号',
  IMPORT_APP_TPL_NAME         varchar(256)                      COMMENT '导入应用模板名称',
  IMPORT_APP_TPL_TYPES        varchar(256)                      COMMENT '导入应用模板类型',
  APP_NAME                    varchar(256)                      COMMENT '应用名称',
  IMPORT_RESULT               text                              COMMENT '导入结果',
  IMPORT_TYPES                varchar(64)                       COMMENT '导入类型',
  OPERATOR                    varchar(64)                       COMMENT '导入操作人',
  CREATE_USER                 varchar(64)                                           ,
  UPDATE_USER                 varchar(64)                                           ,
  CREATE_TIME                 datetime                                              ,
  UPDATE_TIME                 datetime                                              ,
  TENANT_ID                   varchar(64)                                           ,
  FILE_ID                     varchar(64)                       COMMENT '附件文件id',
  PRIMARY KEY (ID)
) ;

DROP TABLE IF EXISTS LC_COMPONENT_GROUP;
CREATE TABLE LC_COMPONENT_GROUP  (
  ID                      VARCHAR(64)           NOT NULL          COMMENT '主键',
  NAME                    VARCHAR(256)                            COMMENT '分组名称',
  CODE                    VARCHAR(64)                             COMMENT '分组编码',
  ICON_CODE               VARCHAR(64)                             COMMENT '图标编码',
  SORT_NO                 DECIMAL(2, 0)                           COMMENT '排序',
  EXTRA                   LONGTEXT                                COMMENT '扩展字段',
  DESCRIPTION             TEXT                                    COMMENT '描述',
  CREATE_TIME             DATETIME                                COMMENT '创建时间',
  UPDATE_TIME             DATETIME                                COMMENT '修改时间',
  CREATE_USER             VARCHAR(64)                             COMMENT '创建者ID',
  UPDATE_USER             VARCHAR(64)                             COMMENT '修改者ID',
  TENANT_ID               VARCHAR(64)                             COMMENT '租户ID',
  APP_NAME                VARCHAR(64)                             COMMENT '应用名称',
  PRIMARY KEY (ID)
) COMMENT = '组件分组表';

DROP TABLE IF EXISTS LC_COMPONENT;
CREATE TABLE LC_COMPONENT  (
  ID                      VARCHAR(64)            NOT NULL         COMMENT '主键',
  NAME                    VARCHAR(256)                            COMMENT '组件名称',
  CODE                    VARCHAR(64)                             COMMENT '组件编码',
  ICON_CODE               VARCHAR(64)                             COMMENT '图标库编码',
  SORT_NO                 DECIMAL(2, 0)                           COMMENT '排序',
  GROUP_ID                VARCHAR(64)                             COMMENT '所属分组ID',
  COMPONENT_CENTER_CODE   VARCHAR(64)                             COMMENT '所属组件中心code',
  VERSION                 VARCHAR(64)                             COMMENT '版本',
  IS_USE                  INT(1)                                  COMMENT '是否当前使用 0：否 1：是',
  CONTENT                 LONGTEXT                                COMMENT '内容',
  EXTRA                   LONGTEXT                                COMMENT '扩展字段',
  DESCRIPTION             TEXT                                    COMMENT '描述',
  FILE_ID                 VARCHAR(64)                             COMMENT '附件ID',
  CREATE_TIME             DATETIME                                COMMENT '创建时间',
  UPDATE_TIME             DATETIME                                COMMENT '修改时间',
  CREATE_USER             VARCHAR(64)                             COMMENT '创建者ID',
  UPDATE_USER             VARCHAR(64)                             COMMENT '修改者ID',
  TENANT_ID               VARCHAR(64)                             COMMENT '租户ID',
  APP_NAME                VARCHAR(64)                             COMMENT '应用名称',
  PRIMARY KEY (ID)
) COMMENT = '组件信息表';

DROP TABLE IF EXISTS LC_RESOURCE_GROUP;
CREATE TABLE LC_RESOURCE_GROUP  (
  ID                      varchar(64)             NOT NULL        COMMENT '主键',
  CODE                    varchar(256)            NOT NULL        COMMENT '编码',
  NAME                    varchar(256)                            COMMENT '显示名称',
  APP_NAME                varchar(64)                             COMMENT '应用名称',
  CONTRIBUTION_ID         varchar(64)                             COMMENT '所属构件包ID',
  GROUP_TYPE              varchar(64)                             COMMENT '分组类型',
  SORT_BY                 decimal(2, 0)                           COMMENT '排序',
  DESCRIPTION             TEXT                                    COMMENT '描述',
  EXTEND                  LONGTEXT                                COMMENT '扩展属性',
  CREATE_USER             varchar(64)                             COMMENT '创建人',
  CREATE_TIME             datetime                                COMMENT '创建时间',
  UPDATE_USER             varchar(64)                             COMMENT '更新人',
  UPDATE_TIME             datetime                                COMMENT '更新时间',
  TENANT_ID               varchar(64)                             COMMENT '租户ID',
  PRIMARY KEY (ID)
) COMMENT = '低开资源分组表';

DROP TABLE IF EXISTS LC_PROJECT_BRANCH;
CREATE TABLE LC_PROJECT_BRANCH  (
  ID                      varchar(64)             NOT NULL        COMMENT '主键',
  NAME                    varchar(256)                            COMMENT '分支名称',
  CODE                    varchar(64)                             COMMENT '分支编码',
  BRANCH_NUM              varchar(64)                             COMMENT '分支版本',
  APP_NAME                varchar(256)                            COMMENT '所属应用名称',
  IS_USE                  int(1)                                  COMMENT '是否当前使用分支 0：否 1：是',
  CONTENT                 longtext                                COMMENT '分支资源内容',
  DESCRIPTION             text                                    COMMENT '分支描述',
  CREATE_USER             varchar(64)                             COMMENT '创建人',
  CREATE_TIME             datetime                                COMMENT '创建时间',
  UPDATE_USER             varchar(64)                             COMMENT '修改人',
  UPDATE_TIME             datetime                                COMMENT '修改时间',
  TENANT_ID               varchar(64)                             COMMENT '租户id',
  PRIMARY KEY (ID)
) COMMENT = '低开资源分支表';

DROP TABLE IF EXISTS LC_RESOURCE_RECYCLE;
CREATE TABLE LC_RESOURCE_RECYCLE  (
  ID                      varchar(64)             NOT NULL        COMMENT '主键',
  RESOURCE_NAME           varchar(256)                            COMMENT '原资源名称',
  RESOURCE_CODE           varchar(256)                             COMMENT '原资源编码',
  RESOURCE_TYPE           varchar(64)                             COMMENT '原资源类型',
  CONTRIBUTION_ID         varchar(64)                             COMMENT '原所属构建包',
  RESOURCE_JSON           longtext                                COMMENT '原资源内容(包含runtime)',
  DELETE_TIME             datetime                                COMMENT '删除时间',
  DELETE_USER             varchar(64)                             COMMENT '删除人',
  APP_NAME                varchar(256)                            COMMENT '所属应用名称',
  PRIMARY KEY (ID)
)  COMMENT = '低开资源回收站表';

DROP TABLE IF EXISTS LC_RESOURCE_SHARE;
CREATE TABLE LC_RESOURCE_SHARE  (
  ID                      varchar(64)              NOT NULL       COMMENT '主键',
  RESOURCE_NAME           varchar(256)                            COMMENT '被分享的资源名称',
  RESOURCE_TYPE           varchar(64)                             COMMENT '被分享的资源类型',
  RESOURCE_SUB_TYPE       varchar(64)                             COMMENT '二级分类',
  RESOURCE_CODE           varchar(256)                            COMMENT '被分享的资源编码',
  SHARE_TYPE              varchar(64)                             COMMENT '分享类型',
  SHARE_RULE              longtext                                COMMENT '分享规则-json',
  APP_NAME                varchar(64)                             COMMENT '所属应用',
  EXTEND                  longtext                                COMMENT '扩展字段',
  CREATE_USER             varchar(64)                             COMMENT '创建者',
  CREATE_TIME             datetime                                COMMENT '创建时间',
  UPDATE_USER             varchar(64)                             COMMENT '修改者',
  UPDATE_TIME             datetime                                COMMENT '修改时间',
  PRIMARY KEY (ID)
) COMMENT = '低开资源分享表';


-- 索引
CREATE INDEX LC_CONTRIBUTION_INDEX ON LC_CONTRIBUTION(APP_NAME, CODE);

CREATE INDEX LC_RESOURCE_INDEX ON LC_RESOURCE(APP_NAME, CONTRIBUTION_ID, CODE);
CREATE INDEX LC_RESOURCE_CONTENT_INDEX ON LC_RESOURCE_CONTENT(CONTRIBUTION_ID);

CREATE INDEX LC_H_RESOURCE_CONTENT_INDEX ON LC_H_RESOURCE_CONTENT(RESOURCE_ID, CONTRIBUTION_ID);

CREATE INDEX LC_RUNTIME_RESOURCE_INDEX ON LC_RUNTIME_RESOURCE(RESOURCE_ID, CONTRIBUTION_ID);

CREATE INDEX LC_BASELINE_APP_NAME_INDEX ON LC_PROJECT_BASELINE(APP_NAME);

DROP TABLE IF EXISTS LC_RESOURCE_BOARD_SORT;
CREATE TABLE LC_RESOURCE_BOARD_SORT (
    RES_SORT_ID         VARCHAR(64)     NOT NULL    COMMENT '看板数据排序主键',
    RESOURCE_CODE       VARCHAR(64)                 COMMENT '资源编码',
    VIEW_CODE           VARCHAR(64)                 COMMENT '视图编码',
    USER_CODE           VARCHAR(64)                 COMMENT '个人账号',
    APP_CODE            VARCHAR(64)                 COMMENT '应用编号',
    SORT_JSON           LONGTEXT                    COMMENT '排序JSON数据',
    PRIMARY KEY (RES_SORT_ID)
)COMMENT='低开看板资源数据排序';

DROP TABLE IF EXISTS LC_RELEASE_RUNTIME_RESOURCE;
CREATE TABLE LC_RELEASE_RUNTIME_RESOURCE  (
  ID                    varchar(64)               NOT NULL            COMMENT '主键',
  RESOURCE_ID           varchar(256)                                  COMMENT '资源id',
  CONTRIBUTION_ID       varchar(256)                                  COMMENT '所属构件包ID',
  SOURCE_MD5            varchar(512)                                  COMMENT '源资源内容摘要',
  FILE_PATH             varchar(512)                                  COMMENT '文件路径',
  CONTENT               longtext                                      COMMENT '内容',
  ENCODING              varchar(64)                                   COMMENT '编码',
  BIN_CONTENT           longblob                                      COMMENT '二进制文件内容',
  CREATE_USER           varchar(64)                                   COMMENT '创建人',
  CREATE_TIME           datetime                                      COMMENT '创建时间',
  UPDATE_USER           varchar(64)                                   COMMENT '更新人',
  UPDATE_TIME           datetime                                      COMMENT '更新时间',
  PRIMARY KEY (ID)
) COMMENT='低开运行时发布资源';

DROP TABLE IF EXISTS LC_WF_PARTICIPANT;
CREATE TABLE LC_WF_PARTICIPANT (
    ID                              varchar(64)     NOT NULL    COMMENT '主键',
    WORKITEM_ID                     bigint(20)                  COMMENT '工作项ID',
    WORKITEM_NAME                   varchar(256)                COMMENT '工作项NAME',
    PROCESS_DEF_ID                  bigint(20)                  COMMENT '流程定义ID',
    PROCESSINST_ID                  bigint(20)                  COMMENT '流程实例ID',
    PROCESSINST_NAME                varchar(256)                COMMENT '流程实例名称',
    PROCESS_DEF_NAME                varchar(256)                COMMENT '流程定义名称',
    PROCESS_CH_NAME                 varchar(256)                COMMENT '流程定义显示名称',
    ACTIVITY_DEF_ID                 varchar(64)                 COMMENT '活动定义ID',
    CURRENT_STATE                   int(20)                     COMMENT '工作项当前状态',
    BIZ_STATE                       varchar(64)                 COMMENT '操作动作状态',
    SYS_FLOW_CURR_ACTIVITYINSTNAME  varchar(256)                COMMENT '活动实例名称',
    SYS_FLOW_CURR_ACTIVITYINSTID    bigint(20)                  COMMENT '活动实例ID',
    SYS_FLOW_CURREMPLD              varchar(20)                 COMMENT '参与者',
    SYS_FLOW_CURR_ORGIDS            varchar(1024)               COMMENT '参与者所在机构，id逗号隔开',
    SYS_FLOW_CURR_TIMES             datetime                    COMMENT '活动到达时间',
    SYS_FLOW_START_EMPLD            varchar(256)                COMMENT '流程启动者ID',
    SYS_FLOW_START_ORGLD            varchar(64)                 COMMENT '发起人机构',
    SYS_FLOW_START_TIME             datetime                    COMMENT '流程发起时间',
    BPS_TENANT_ID                   varchar(64)                 COMMENT 'BPS租户ID',
    TENANT_ID                       varchar(64)                 COMMENT '租户ID',
    ENTITY_NAME                     varchar(256)                COMMENT '业务实体名称',
    ENTITY_PRIMARY_VALUE            varchar(1024)               COMMENT '业务表主键值',
    PRIMARY KEY (ID)
) COMMENT='业务流程权限关系表';

DROP TABLE IF EXISTS LC_WF_PROCESSINST;
CREATE TABLE LC_WF_PROCESSINST (
    ID                              varchar(64)     NOT NULL  COMMENT '主键',
    PROCESS_DEF_ID                  DECIMAL(20, 0)            COMMENT '流程定义id' ,
    PROCESS_INST_ID                  DECIMAL(20, 0)            COMMENT '流程实例id',
    PROCESS_INST_NAME                varchar(256)              COMMENT '流程实例名称',
    PROCESS_DEF_NAME                varchar(256)              COMMENT '流程定义名称',
    PROCESS_CH_NAME                 varchar(256)              COMMENT '流程显示名称',
    CURRENT_STATE                   int                       COMMENT '流程状态',
    BPS_TENANT_ID                   varchar(64)               COMMENT 'bps租户id',
    APP_NAME						varchar(64)               COMMENT '应用code',
    TENANT_ID                       varchar(64)               COMMENT 'afc租户id',
    ENTITY_NAME                     varchar(256)              COMMENT '流程主实体名称',
    ENTITY_PRIMARY_VALUE            varchar(1024)             COMMENT '流程主实体业务主键值',
    EXTEND							varchar(1024)			  COMMENT '扩展字段',
    PRIMARY KEY (ID)
) COMMENT='业务流程状态关系表';


