

/*==============================================================*/
/* Table: LC_CONTRIBUTION                                   */
/*==============================================================*/

CREATE TABLE LC_CONTRIBUTION  (
  ID                         VARCHAR(64)        NOT NULL   ,
  CODE                       VARCHAR(256)                  ,
  NAME                       VARCHAR(256)                   ,
  CATEGORY                   VARCHAR(64)                   ,
  APP_NAME			      	 VARCHAR(64)                   ,
  DESCRIPTION                CLOB                           ,
  EXTEND                     CLOB                           ,
  DEL_FLAG                   CHAR                           ,
  CREATE_USER                VARCHAR(64)                   ,
  CREATE_TIME                DATE                           ,
  UPDATE_USER                VARCHAR(64)                   ,
  UPDATE_TIME                DATE                           ,
  TENANT_ID                  VARCHAR(64)                   ,
  ONLINE_TYPE                VARCHAR(64)                   , 
  BI_FOLDER                  VARCHAR(64)                   ,
  PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: LC_RESOURCE                                       */
/*==============================================================*/
CREATE TABLE LC_RESOURCE  (
  ID                         VARCHAR(64)        NOT NULL  ,
  CODE                       VARCHAR(256)                 ,
  NAME                       VARCHAR(256)                  ,
  RESOURCE_TYPE              VARCHAR(64)                  ,
  APP_NAME			      	 VARCHAR(64)                  ,
  CONTRIBUTION_ID			 VARCHAR(64)                  ,
  DESCRIPTION                CLOB                          ,
  MD5                        VARCHAR(512)                 ,
  RUNTIME_MD5                VARCHAR(512)   ,
  FILE_PATH                  VARCHAR(512)                 ,
  STATUS                     VARCHAR(64)     ,
  CHANGE_VERSION             INT             ,
  EXTEND                     CLOB                          ,
  DEL_FLAG                   CHAR                          ,
  CREATE_USER                VARCHAR(64)                  ,
  CREATE_TIME                DATE                          ,
  UPDATE_USER                VARCHAR(64)                  ,
  UPDATE_TIME                DATE                          ,
  TENANT_ID                  VARCHAR(64)                  ,
  CATEGORY1                  VARCHAR(256)    ,
  CATEGORY2                  VARCHAR(256)    ,
  CATEGORY3                  VARCHAR(256)    ,
  BI_RESOURCE                VARCHAR(256)                 ,
  RESOURCE_SUB_TYPE          VARCHAR(256)                 ,
  RESOURCE_GROUP_ID          VARCHAR(64)     ,
  PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: LC_RESOURCE_CONTENT                               */
/*==============================================================*/

CREATE TABLE LC_RESOURCE_CONTENT  (
  ID                         VARCHAR(64)        NOT NULL  ,
  CONTRIBUTION_ID			 VARCHAR(64)                  ,
  CONTENT                    CLOB                          ,
  ENCODING                   VARCHAR(64)                  ,
  BIN_CONTENT                BLOB                          ,
  EXTEND                     CLOB             ,
  PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: LC_H_RESOURCE_CONTENT                               */
/*==============================================================*/

CREATE TABLE LC_H_RESOURCE_CONTENT  (
  ID                         VARCHAR(64)        NOT NULL  ,
  RESOURCE_ID    	      	 VARCHAR(64)                  ,
  CONTRIBUTION_ID			 VARCHAR(64)                  ,
  MD5                        VARCHAR(512)  ,
  CONTENT                    CLOB                          ,
  ENCODING                   VARCHAR(64)                  ,
  BIN_CONTENT                BLOB                          ,
  COMMIT_VERSION             VARCHAR(64)                  ,
  COMMIT_MESSAGE             VARCHAR(512)                 ,
  UPDATE_USER                VARCHAR(64)                  ,
  UPDATE_TIME                DATE                          ,
  EXTEND                     CLOB             ,
  PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: LC_RUNTIME_RESOURCE                               */
/*==============================================================*/

CREATE TABLE LC_RUNTIME_RESOURCE  (
  ID                         VARCHAR(64)        NOT NULL   ,
  RESOURCE_ID    	      	 VARCHAR(64)                   ,
  CONTRIBUTION_ID			 VARCHAR(64)                   ,
  SOURCE_MD5                 VARCHAR(512)                  ,
  FILE_PATH                  VARCHAR(512)                  ,
  CONTENT                    CLOB                           ,
  ENCODING                   VARCHAR(64)                  ,
  BIN_CONTENT                BLOB                          ,
  CREATE_USER                VARCHAR(64)                   ,
  CREATE_TIME                DATE                           ,
  UPDATE_USER                VARCHAR(64)                   ,
  UPDATE_TIME                DATE                           ,
  PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: LC_R_ENTITY_DATASOURCE                                   */
/*==============================================================*/

CREATE TABLE LC_R_ENTITY_DATASOURCE
(
   APP_NAME              VARCHAR(64) not null ,
   DATASOURCE_NAME       VARCHAR(64) not null ,
   ENTITY_NAME_INCLUDES  VARCHAR(512) ,
   ENTITY_NAME_EXCLUDES  VARCHAR(512) ,
   primary key(APP_NAME, DATASOURCE_NAME)
) ;

/*==============================================================*/
/* Table: LC_PROJECT_BASELINE                                   */
/*==============================================================*/

CREATE TABLE LC_PROJECT_BASELINE  (
  ID                        VARCHAR(64)           NOT NULL      ,
  NAME                      VARCHAR(256)                        ,
  CODE                      VARCHAR(256)                        ,
  TAG_NUM                   VARCHAR(64)                         ,
  APP_NAME                VARCHAR(64)                         ,
  IS_USE                    INT                                 ,
  RESOURCE_BASELINE_DATA    CLOB                                ,
  DESCRIPTION               CLOB                                ,
  CREATE_USER               VARCHAR(64)                         ,
  CREATE_TIME               DATE                                ,
  UPDATE_USER               VARCHAR(64)                         ,
  UPDATE_TIME               DATE                                ,
  TENANT_ID                 VARCHAR(64)                         ,
  PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: LC_PROJECT_SNAPSHOT                                   */
/*==============================================================*/

CREATE TABLE LC_PROJECT_SNAPSHOT  (
  APP_NAME                        VARCHAR(64)           NOT NULL      ,
  CONTENT                   CLOB                                ,
  PRIMARY KEY (APP_NAME)
);

CREATE TABLE LC_R_RESOURCE_RELATION  (
  ID                          VARCHAR(64)       NOT NULL    ,
  SOURCE_CODE                 VARCHAR(512)                  ,
  SOURCE_SUB_ID               VARCHAR(512)                  ,
  SOURCE_TYPE                 VARCHAR(64)                   ,
  SOURCE_CATEGORY             VARCHAR(64)                   ,
  TARGET_CODE                 VARCHAR(512)                  ,
  TARGET_SUB_ID               VARCHAR(512)                  ,
  TARGET_TYPE                 VARCHAR(64)                   ,
  TARGET_CATEGORY             VARCHAR(64)                   ,
  APP_NAME			      	      VARCHAR(64)                   ,
  PRIMARY KEY (ID)
) ;


CREATE TABLE LC_R_BI_DATASOURCE_RELATION
(
    ID                       VARCHAR(64)        NOT NULL 	 ,
    APP_NAME                 VARCHAR(64)        NOT NULL 	 ,
    DATASOURCE_ID            VARCHAR(64)        NOT NULL 	 ,
    DATASOURCE_NAME          VARCHAR(256)       NOT NULL     ,
    PRIMARY KEY (ID)
);


CREATE TABLE LC_IMPORT_HISTORY  (
  ID                          varchar(64)       NOT NULL        ,
  IMPORT_BASELINE_NAME        varchar(256)                      ,
  IMPORT_BASELINE_NUM         varchar(64)                       ,
  IMPORT_APP_TPL_NAME         varchar(256)                      ,
  IMPORT_APP_TPL_TYPES        varchar(256)                      ,
  APP_NAME                    varchar(256)                      ,
  IMPORT_RESULT               CLOB                              ,
  IMPORT_TYPES                varchar(64)                       ,
  OPERATOR                    varchar(64)                       ,
  CREATE_USER                 varchar(64)                                           ,
  UPDATE_USER                 varchar(64)                                           ,
  CREATE_TIME                 DATE                                              ,
  UPDATE_TIME                 DATE                                              ,
  TENANT_ID                   varchar(64)                                           ,
  FILE_ID                     varchar(64)                       ,
  PRIMARY KEY (ID)
) ;


CREATE TABLE LC_COMPONENT_GROUP  (
  ID                      VARCHAR2(64)           NOT NULL           ,
  NAME                    VARCHAR2(256)                             ,
  CODE                    VARCHAR2(64)                              ,
  ICON_CODE               VARCHAR2(64)                              ,
  SORT_NO                 NUMBER(2, 0)                            ,
  EXTRA                   CLOB                                     ,
  DESCRIPTION             CLOB                                     ,
  CREATE_TIME             DATE                                 ,
  UPDATE_TIME             DATE                                 ,
  CREATE_USER             VARCHAR2(64)                              ,
  UPDATE_USER             VARCHAR2(64)                              ,
  TENANT_ID               VARCHAR2(64)                              ,
  APP_NAME                VARCHAR2(64)                              ,
  PRIMARY KEY (ID)
) ;


CREATE TABLE LC_COMPONENT  (
  ID                      VARCHAR2(64)            NOT NULL          ,
  NAME                    VARCHAR2(256)                             ,
  CODE                    VARCHAR2(64)                              ,
  ICON_CODE               VARCHAR2(64)                              ,
  SORT_NO                 NUMBER(2, 0)                            ,
  GROUP_ID                VARCHAR2(64)                              ,
  COMPONENT_CENTER_CODE   VARCHAR2(64)                              ,
  VERSION                 VARCHAR2(64)                              ,
  IS_USE                  NUMBER(11)                                      ,
  CONTENT                 CLOB                                     ,
  EXTRA                   CLOB                                     ,
  DESCRIPTION             CLOB                                     ,
  FILE_ID                 VARCHAR2(64)                              ,
  CREATE_TIME             DATE                                ,
  UPDATE_TIME             DATE                                ,
  CREATE_USER             VARCHAR2(64)                              ,
  UPDATE_USER             VARCHAR2(64)                              ,
  TENANT_ID               VARCHAR2(64)                              ,
  APP_NAME                VARCHAR2(64)                              ,
  PRIMARY KEY (ID)
) ;

CREATE TABLE LC_RESOURCE_GROUP  (
  ID                      VARCHAR2(64)             NOT NULL         ,
  CODE                    VARCHAR2(256)            NOT NULL         ,
  NAME                    VARCHAR2(256)                             ,
  APP_NAME                VARCHAR2(64)                              ,
  CONTRIBUTION_ID         VARCHAR2(64)                              ,
  GROUP_TYPE              VARCHAR2(64)                              ,
  SORT_BY                 NUMBER(2, 0)                            ,
  DESCRIPTION             CLOB                                     ,
  EXTEND                  CLOB                                     ,
  CREATE_USER             VARCHAR2(64)                              ,
  CREATE_TIME             DATE                                 ,
  UPDATE_USER             VARCHAR2(64)                              ,
  UPDATE_TIME             DATE                                 ,
  TENANT_ID               VARCHAR2(64)                              ,
  PRIMARY KEY (ID)
)  ;

CREATE TABLE LC_PROJECT_BRANCH  (
  ID                      VARCHAR2(64)             NOT NULL        ,
  NAME                    VARCHAR2(256)                            ,
  CODE                    VARCHAR2(64)                             ,
  BRANCH_NUM              VARCHAR2(64)                             ,
  APP_NAME                VARCHAR2(256)                            ,
  IS_USE                  NUMBER(11)                                  ,
  CONTENT                 CLOB                                ,
  DESCRIPTION             CLOB                                    ,
  CREATE_USER             VARCHAR2(64)                             ,
  CREATE_TIME             DATE                                ,
  UPDATE_USER             VARCHAR2(64)                             ,
  UPDATE_TIME             DATE                                ,
  TENANT_ID               VARCHAR2(64)                             ,
  PRIMARY KEY (ID)
) ;

CREATE TABLE LC_RESOURCE_RECYCLE  (
  ID                      VARCHAR2(64)             NOT NULL         ,
  RESOURCE_NAME           VARCHAR2(256)                             ,
  RESOURCE_CODE           VARCHAR2(256)                              ,
  RESOURCE_TYPE           VARCHAR2(64)                              ,
  CONTRIBUTION_ID         VARCHAR2(64)                              ,
  RESOURCE_JSON           CLOB                                 ,
  DELETE_TIME             DATE                                 ,
  DELETE_USER             VARCHAR2(64)                              ,
  APP_NAME                VARCHAR2(256)                            ,
  PRIMARY KEY (ID)
)  ;

CREATE TABLE LC_RESOURCE_SHARE  (
  ID                      varchar(64)              NOT NULL       ,
  RESOURCE_NAME           varchar(256)                            ,
  RESOURCE_TYPE           varchar(64)                             ,
  RESOURCE_SUB_TYPE       varchar(64)                             ,
  RESOURCE_CODE           varchar(256)                            ,
  SHARE_TYPE              varchar(64)                             ,
  SHARE_RULE              CLOB                                    ,
  APP_NAME                varchar(64)                             ,
  EXTEND                  varchar(1024)                                    ,
  CREATE_USER             varchar(64)                             ,
  CREATE_TIME             DATE                               ,
  UPDATE_USER             varchar(64)                             ,
  UPDATE_TIME             DATE                               ,
  PRIMARY KEY (ID)
) ;

-- 索引
CREATE INDEX LC_CONTRIBUTION_INDEX ON LC_CONTRIBUTION(APP_NAME, CODE);

CREATE INDEX LC_RESOURCE_INDEX ON LC_RESOURCE(APP_NAME, CONTRIBUTION_ID, CODE);
CREATE INDEX LC_RESOURCE_CONTENT_INDEX ON LC_RESOURCE_CONTENT(CONTRIBUTION_ID);

CREATE INDEX LC_H_RESOURCE_CONTENT_INDEX ON LC_H_RESOURCE_CONTENT(RESOURCE_ID, CONTRIBUTION_ID);

CREATE INDEX LC_RUNTIME_RESOURCE_INDEX ON LC_RUNTIME_RESOURCE(RESOURCE_ID, CONTRIBUTION_ID);

CREATE INDEX LC_BASELINE_APP_NAME_INDEX ON LC_PROJECT_BASELINE(APP_NAME);

CREATE TABLE LC_RESOURCE_BOARD_SORT (
    RES_SORT_ID         VARCHAR2(64)     NOT NULL    ,
    RESOURCE_CODE       VARCHAR2(64)                 ,
    VIEW_CODE           VARCHAR2(64)                 ,
    USER_CODE           VARCHAR2(64)                 ,
    APP_CODE            VARCHAR2(64)                 ,
    SORT_JSON           CLOB                        ,
    PRIMARY KEY (RES_SORT_ID)
);

CREATE TABLE LC_RELEASE_RUNTIME_RESOURCE  (
  ID                         VARCHAR(64)        NOT NULL   ,
  RESOURCE_ID    	      	 VARCHAR(64)                   ,
  CONTRIBUTION_ID			 VARCHAR(64)                   ,
  SOURCE_MD5                 VARCHAR(512)                  ,
  FILE_PATH                  VARCHAR(512)                  ,
  CONTENT                    CLOB                           ,
  ENCODING                   VARCHAR(64)                  ,
  BIN_CONTENT                BLOB                          ,
  CREATE_USER                VARCHAR(64)                   ,
  CREATE_TIME                DATE                           ,
  UPDATE_USER                VARCHAR(64)                   ,
  UPDATE_TIME                DATE                           ,
  PRIMARY KEY (ID)
);

CREATE TABLE LC_WF_PARTICIPANT (
    ID                              VARCHAR2(64)     NOT NULL  ,
    WORKITEM_ID                     NUMBER              ,
    WORKITEM_NAME                   VARCHAR2(256)              ,
    PROCESS_DEF_ID                  NUMBER            ,
    PROCESSINST_ID                  NUMBER             ,
    PROCESSINST_NAME                VARCHAR2(256)              ,
    PROCESS_DEF_NAME                VARCHAR2(256)              ,
    PROCESS_CH_NAME                 VARCHAR2(256)              ,
    ACTIVITY_DEF_ID                 VARCHAR2(64)               ,
    CURRENT_STATE                   INT                       ,
    BIZ_STATE                       VARCHAR2(64)               ,
    SYS_FLOW_CURR_ACTIVITYINSTNAME  VARCHAR2(256)              ,
    SYS_FLOW_CURR_ACTIVITYINSTID    NUMBER                ,
    SYS_FLOW_CURREMPLD              VARCHAR2(20)               ,
    SYS_FLOW_CURR_ORGIDS            VARCHAR2(1024)              ,
    SYS_FLOW_CURR_TIMES             DATE                  ,
    SYS_FLOW_START_EMPLD            VARCHAR2(256)              ,
    SYS_FLOW_START_ORGLD            VARCHAR2(64)               ,
    SYS_FLOW_START_TIME             DATE                  ,
    BPS_TENANT_ID                   VARCHAR2(64)               ,
    TENANT_ID                       VARCHAR2(64)               ,
    ENTITY_NAME                     VARCHAR2(256)              ,
    ENTITY_PRIMARY_VALUE            VARCHAR2(1024)             ,
    PRIMARY KEY (ID)
);

CREATE TABLE LC_WF_PROCESSINST (
    ID                              VARCHAR2(64)     NOT NULL  ,
    PROCESS_DEF_ID                  NUMBER            ,
    PROCESS_INST_ID                  NUMBER            ,
    PROCESS_INST_NAME                VARCHAR2(256)              ,
    PROCESS_DEF_NAME                VARCHAR2(256)              ,
    PROCESS_CH_NAME                 VARCHAR2(256)              ,
    CURRENT_STATE                   INT                       ,
    BPS_TENANT_ID                   VARCHAR2(64)               ,
    APP_NAME						VARCHAR2(64)               ,
    TENANT_ID                       VARCHAR2(64)               ,
    ENTITY_NAME                     VARCHAR2(256)              ,
    ENTITY_PRIMARY_VALUE            VARCHAR2(1024)             ,
    EXTEND							VARCHAR2(1024)			  ,
    PRIMARY KEY (ID)
);

