/*==============================================================*/
/* Table: LC_CONTRIBUTION                                   */
/*==============================================================*/
IF OBJECT_ID('LC_CONTRIBUTION') IS NOT NULL
DROP TABLE LC_CONTRIBUTION;
CREATE TABLE LC_CONTRIBUTION
(
    ID          NVARCHAR(64) NOT NULL,
    CODE        NVARCHAR(256),
    NAME        NVARCHAR(256),
    CATEGORY    NVARCHAR(64),
    APP_NAME    NVARCHAR(64),
    DESCRIPTION NVARCHAR(max),
    EXTEND      NVARCHAR(max),
    DEL_FLAG    NCHAR,
    CREATE_USER NVARCHAR(64),
    CREATE_TIME DATETIME2,
    UPDATE_USER NVARCHAR(64),
    UPDATE_TIME DATETIME2,
    TENANT_ID   NVARCHAR(64),
    ONLINE_TYPE NVARCHAR(64),
    BI_FOLDER   NVARCHAR(64),
    PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: LC_RESOURCE                                       */
/*==============================================================*/
IF OBJECT_ID('LC_RESOURCE') IS NOT NULL
DROP TABLE LC_RESOURCE;
CREATE TABLE LC_RESOURCE
(
    ID                NVARCHAR(64) NOT NULL,
    CODE              NVARCHAR(256),
    NAME              NVARCHAR(256),
    RESOURCE_TYPE     NVARCHAR(64),
    APP_NAME          NVARCHAR(64),
    CONTRIBUTION_ID   NVARCHAR(64),
    DESCRIPTION       NVARCHAR(max),
    MD5               NVARCHAR(512),
    RUNTIME_MD5       NVARCHAR(512),
    FILE_PATH         NVARCHAR(512),
    STATUS            NVARCHAR(64),
    CHANGE_VERSION    INT,
    EXTEND            NVARCHAR(max),
    DEL_FLAG          NCHAR,
    CREATE_USER       NVARCHAR(64),
    CREATE_TIME       DATETIME2,
    UPDATE_USER       NVARCHAR(64),
    UPDATE_TIME       DATETIME2,
    TENANT_ID         NVARCHAR(64),
    CATEGORY1         NVARCHAR(256),
    CATEGORY2         NVARCHAR(256),
    CATEGORY3         NVARCHAR(256),
    BI_RESOURCE       NVARCHAR(256),
    RESOURCE_SUB_TYPE NVARCHAR(256),
    RESOURCE_GROUP_ID          NVARCHAR(64)     ,
    PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: LC_RESOURCE_CONTENT                               */
/*==============================================================*/
IF OBJECT_ID('LC_RESOURCE_CONTENT') IS NOT NULL
DROP TABLE LC_RESOURCE_CONTENT;
CREATE TABLE LC_RESOURCE_CONTENT
(
    ID              NVARCHAR(64) NOT NULL,
    CONTRIBUTION_ID NVARCHAR(64),
    CONTENT         NVARCHAR(max),
    ENCODING        NVARCHAR(64),
    BIN_CONTENT     VARBINARY(max),
    EXTEND          NVARCHAR(max),
    PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: LC_H_RESOURCE_CONTENT                               */
/*==============================================================*/
IF OBJECT_ID('LC_H_RESOURCE_CONTENT') IS NOT NULL
DROP TABLE LC_H_RESOURCE_CONTENT;
CREATE TABLE LC_H_RESOURCE_CONTENT
(
    ID              NVARCHAR(64) NOT NULL,
    RESOURCE_ID     NVARCHAR(64),
    CONTRIBUTION_ID NVARCHAR(64),
    MD5             NVARCHAR(512),
    CONTENT         NVARCHAR(max),
    ENCODING        NVARCHAR(64),
    BIN_CONTENT     VARBINARY(max),
    COMMIT_VERSION  NVARCHAR(64),
    COMMIT_MESSAGE  NVARCHAR(512),
    UPDATE_USER     NVARCHAR(64),
    UPDATE_TIME     DATETIME2,
    EXTEND          NVARCHAR(max),
    PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: LC_RUNTIME_RESOURCE                               */
/*==============================================================*/
IF OBJECT_ID('LC_RUNTIME_RESOURCE') IS NOT NULL
DROP TABLE LC_RUNTIME_RESOURCE;
CREATE TABLE LC_RUNTIME_RESOURCE
(
    ID              NVARCHAR(64) NOT NULL,
    RESOURCE_ID     NVARCHAR(64),
    CONTRIBUTION_ID NVARCHAR(64),
    SOURCE_MD5      NVARCHAR(512),
    FILE_PATH       NVARCHAR(512),
    CONTENT         NVARCHAR(max),
    ENCODING        NVARCHAR(64),
    BIN_CONTENT     VARBINARY(max),
    CREATE_USER     NVARCHAR(64),
    CREATE_TIME     DATETIME2,
    UPDATE_USER     NVARCHAR(64),
    UPDATE_TIME     DATETIME2,
    PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: LC_R_ENTITY_DATASOURCE                                   */
/*==============================================================*/
IF OBJECT_ID('LC_R_ENTITY_DATASOURCE') IS NOT NULL
DROP TABLE LC_R_ENTITY_DATASOURCE;
CREATE TABLE LC_R_ENTITY_DATASOURCE
(
    APP_NAME             NVARCHAR(64) not null,
    DATASOURCE_NAME      NVARCHAR(64) not null,
    ENTITY_NAME_INCLUDES NVARCHAR(512),
    ENTITY_NAME_EXCLUDES NVARCHAR(512),
    primary key (APP_NAME, DATASOURCE_NAME)
);

/*==============================================================*/
/* Table: LC_PROJECT_BASELINE                                   */
/*==============================================================*/
IF OBJECT_ID('LC_PROJECT_BASELINE') IS NOT NULL
DROP TABLE LC_PROJECT_BASELINE;
CREATE TABLE LC_PROJECT_BASELINE
(
    ID                     NVARCHAR(64) NOT NULL,
    NAME                   NVARCHAR(256),
    CODE                   NVARCHAR(256),
    TAG_NUM                NVARCHAR(64),
    APP_NAME               NVARCHAR(64),
    IS_USE                 INT,
    RESOURCE_BASELINE_DATA NVARCHAR(max),
    DESCRIPTION            NVARCHAR(max),
    CREATE_USER            NVARCHAR(64),
    CREATE_TIME            DATETIME2,
    UPDATE_USER            NVARCHAR(64),
    UPDATE_TIME            DATETIME2,
    TENANT_ID              NVARCHAR(64),
    PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: LC_PROJECT_SNAPSHOT                                   */
/*==============================================================*/
IF OBJECT_ID('LC_PROJECT_SNAPSHOT') IS NOT NULL
DROP TABLE LC_PROJECT_SNAPSHOT;
CREATE TABLE LC_PROJECT_SNAPSHOT
(
    APP_NAME NVARCHAR(64) NOT NULL,
    CONTENT  NVARCHAR(max),
    PRIMARY KEY (APP_NAME)
);

IF OBJECT_ID('LC_R_RESOURCE_RELATION') IS NOT NULL
DROP TABLE LC_R_RESOURCE_RELATION;
CREATE TABLE LC_R_RESOURCE_RELATION
(
    ID              NVARCHAR(64) NOT NULL,
    SOURCE_CODE     NVARCHAR(512),
    SOURCE_SUB_ID   NVARCHAR(512),
    SOURCE_TYPE     NVARCHAR(64),
    SOURCE_CATEGORY NVARCHAR(64),
    TARGET_CODE     NVARCHAR(512),
    TARGET_SUB_ID   NVARCHAR(512),
    TARGET_TYPE     NVARCHAR(64),
    TARGET_CATEGORY NVARCHAR(64),
    APP_NAME        NVARCHAR(64),
    PRIMARY KEY (ID)
);

IF OBJECT_ID('LC_R_BI_DATASOURCE_RELATION') IS NOT NULL
DROP TABLE LC_R_BI_DATASOURCE_RELATION;
CREATE TABLE LC_R_BI_DATASOURCE_RELATION
(
    ID              NVARCHAR(64)  NOT NULL,
    APP_NAME        NVARCHAR(64)  NOT NULL,
    DATASOURCE_ID   NVARCHAR(64)  NOT NULL,
    DATASOURCE_NAME NVARCHAR(256) NOT NULL,
    PRIMARY KEY (ID)
);

IF OBJECT_ID('LC_IMPORT_HISTORY') IS NOT NULL
DROP TABLE LC_IMPORT_HISTORY;
CREATE TABLE LC_IMPORT_HISTORY
(
    ID                   NVARCHAR(64) NOT NULL,
    IMPORT_BASELINE_NAME NVARCHAR(256),
    IMPORT_BASELINE_NUM  NVARCHAR(64),
    IMPORT_APP_TPL_NAME  NVARCHAR(256),
    IMPORT_APP_TPL_TYPES NVARCHAR(256),
    APP_NAME             NVARCHAR(256),
    IMPORT_RESULT        NVARCHAR(max),
    IMPORT_TYPES         NVARCHAR(64),
    OPERATOR             NVARCHAR(64),
    CREATE_USER          NVARCHAR(64),
    UPDATE_USER          NVARCHAR(64),
    CREATE_TIME          DATETIME2,
    UPDATE_TIME          DATETIME2,
    TENANT_ID            NVARCHAR(64),
    FILE_ID              NVARCHAR(64),
    PRIMARY KEY (ID)
);

IF OBJECT_ID('LC_COMPONENT_GROUP') IS NOT NULL
DROP TABLE LC_COMPONENT_GROUP;
CREATE TABLE LC_COMPONENT_GROUP  (
  ID                      NVARCHAR(64)           NOT NULL           ,
  NAME                    NVARCHAR(256)                             ,
  CODE                    NVARCHAR(64)                              ,
  ICON_CODE               NVARCHAR(64)                              ,
  SORT_NO                 DECIMAL(2, 0)                            ,
  EXTRA                   NVARCHAR(max)                                     ,
  DESCRIPTION             NVARCHAR(max)                                     ,
  CREATE_TIME             DATETIME2                                 ,
  UPDATE_TIME             DATETIME2                                 ,
  CREATE_USER             NVARCHAR(64)                              ,
  UPDATE_USER             NVARCHAR(64)                              ,
  TENANT_ID               NVARCHAR(64)                              ,
  APP_NAME                NVARCHAR(64)                              ,
  PRIMARY KEY (ID)
) ;

IF OBJECT_ID('LC_COMPONENT') IS NOT NULL
DROP TABLE LC_COMPONENT;
CREATE TABLE LC_COMPONENT  (
  ID                      NVARCHAR(64)            NOT NULL          ,
  NAME                    NVARCHAR(256)                             ,
  CODE                    NVARCHAR(64)                              ,
  ICON_CODE               NVARCHAR(64)                              ,
  SORT_NO                 DECIMAL(2, 0)                            ,
  GROUP_ID                NVARCHAR(64)                              ,
  COMPONENT_CENTER_CODE   NVARCHAR(64)                              ,
  VERSION                 NVARCHAR(64)                              ,
  IS_USE                  INT                                      ,
  CONTENT                 NVARCHAR(max)                                     ,
  EXTRA                   NVARCHAR(max)                                     ,
  DESCRIPTION             NVARCHAR(max)                                     ,
  FILE_ID                 NVARCHAR(64)                              ,
  CREATE_TIME             DATETIME2                                ,
  UPDATE_TIME             DATETIME2                                ,
  CREATE_USER             NVARCHAR(64)                              ,
  UPDATE_USER             NVARCHAR(64)                              ,
  TENANT_ID               NVARCHAR(64)                              ,
  APP_NAME                NVARCHAR(64)                              ,
  PRIMARY KEY (ID)
) ;

IF OBJECT_ID('LC_RESOURCE_GROUP') IS NOT NULL
DROP TABLE LC_RESOURCE_GROUP;
CREATE TABLE LC_RESOURCE_GROUP  (
  ID                      NVARCHAR(64)             NOT NULL         ,
  CODE                    NVARCHAR(256)            NOT NULL         ,
  NAME                    NVARCHAR(256)                             ,
  APP_NAME                NVARCHAR(64)                              ,
  CONTRIBUTION_ID         NVARCHAR(64)                              ,
  GROUP_TYPE              NVARCHAR(64)                              ,
  SORT_BY                 DECIMAL(2, 0)                            ,
  DESCRIPTION             NVARCHAR(max)                                     ,
  EXTEND                  NVARCHAR(max)                                     ,
  CREATE_USER             NVARCHAR(64)                              ,
  CREATE_TIME             DATETIME2                                 ,
  UPDATE_USER             NVARCHAR(64)                              ,
  UPDATE_TIME             DATETIME2                                 ,
  TENANT_ID               NVARCHAR(64)                              ,
  PRIMARY KEY (ID)
)  ;

IF OBJECT_ID('LC_PROJECT_BRANCH') IS NOT NULL
DROP TABLE IF EXISTS LC_PROJECT_BRANCH;
CREATE TABLE LC_PROJECT_BRANCH  (
  ID                      NVARCHAR(64)             NOT NULL        ,
  NAME                    NVARCHAR(256)                            ,
  CODE                    NVARCHAR(64)                             ,
  BRANCH_NUM              NVARCHAR(64)                             ,
  APP_NAME                NVARCHAR(256)                            ,
  IS_USE                  INT                                  ,
  CONTENT                 NVARCHAR(max)                                ,
  DESCRIPTION             NVARCHAR(max)                                    ,
  CREATE_USER             NVARCHAR(64)                             ,
  CREATE_TIME             DATETIME2                                ,
  UPDATE_USER             NVARCHAR(64)                             ,
  UPDATE_TIME             DATETIME2                                ,
  TENANT_ID               NVARCHAR(64)                             ,
  PRIMARY KEY (ID)
) ;

IF OBJECT_ID('LC_RESOURCE_RECYCLE') IS NOT NULL
DROP TABLE IF EXISTS LC_RESOURCE_RECYCLE;
CREATE TABLE LC_RESOURCE_RECYCLE  (
  ID                      NVARCHAR(64)             NOT NULL         ,
  RESOURCE_NAME           NVARCHAR(256)                             ,
  RESOURCE_CODE           NVARCHAR(256)                              ,
  RESOURCE_TYPE           NVARCHAR(64)                              ,
  CONTRIBUTION_ID         NVARCHAR(64)                              ,
  RESOURCE_JSON           NVARCHAR(max)                                 ,
  DELETE_TIME             DATETIME2                                 ,
  DELETE_USER             NVARCHAR(64)                              ,
  APP_NAME                NVARCHAR(256)                            ,
  PRIMARY KEY (ID)
)  ;

IF OBJECT_ID('LC_RESOURCE_SHARE') IS NOT NULL
DROP TABLE IF EXISTS LC_RESOURCE_SHARE;
CREATE TABLE LC_RESOURCE_SHARE  (
  ID                      NVARCHAR(64)              NOT NULL       ,
  RESOURCE_NAME           NVARCHAR(256)                            ,
  RESOURCE_TYPE           NVARCHAR(64)                             ,
  RESOURCE_SUB_TYPE       NVARCHAR(64)                             ,
  RESOURCE_CODE           NVARCHAR(256)                            ,
  SHARE_TYPE              NVARCHAR(64)                             ,
  SHARE_RULE              NVARCHAR(max)                                    ,
  APP_NAME                NVARCHAR(64)                             ,
  EXTEND                  NVARCHAR(max)                                    ,
  CREATE_USER             NVARCHAR(64)                             ,
  CREATE_TIME             DATETIME2                               ,
  UPDATE_USER             NVARCHAR(64)                             ,
  UPDATE_TIME             DATETIME2                               ,
  PRIMARY KEY (ID)
) ;

-- 索引
CREATE INDEX LC_CONTRIBUTION_INDEX ON LC_CONTRIBUTION (APP_NAME, CODE);

CREATE INDEX LC_RESOURCE_INDEX ON LC_RESOURCE (APP_NAME, CONTRIBUTION_ID, CODE);
CREATE INDEX LC_RESOURCE_CONTENT_INDEX ON LC_RESOURCE_CONTENT (CONTRIBUTION_ID);

CREATE INDEX LC_H_RESOURCE_CONTENT_INDEX ON LC_H_RESOURCE_CONTENT (RESOURCE_ID, CONTRIBUTION_ID);

CREATE INDEX LC_RUNTIME_RESOURCE_INDEX ON LC_RUNTIME_RESOURCE (RESOURCE_ID, CONTRIBUTION_ID);

CREATE INDEX LC_BASELINE_APP_NAME_INDEX ON LC_PROJECT_BASELINE (APP_NAME);

IF OBJECT_ID('LC_RESOURCE_BOARD_SORT') IS NOT NULL
DROP TABLE IF EXISTS LC_RESOURCE_BOARD_SORT;
CREATE TABLE LC_RESOURCE_BOARD_SORT (
    RES_SORT_ID         NVARCHAR(64)     NOT NULL    ,
    RESOURCE_CODE       NVARCHAR(64)                 ,
    VIEW_CODE           NVARCHAR(64)                 ,
    USER_CODE           NVARCHAR(64)                 ,
    APP_CODE            NVARCHAR(64)                 ,
    SORT_JSON           NVARCHAR(max)                         ,
    PRIMARY KEY (RES_SORT_ID)
);

IF OBJECT_ID('LC_RELEASE_RUNTIME_RESOURCE') IS NOT NULL
DROP TABLE LC_RELEASE_RUNTIME_RESOURCE;
CREATE TABLE LC_RELEASE_RUNTIME_RESOURCE
(
    ID              NVARCHAR(64) NOT NULL,
    RESOURCE_ID     NVARCHAR(64),
    CONTRIBUTION_ID NVARCHAR(64),
    SOURCE_MD5      NVARCHAR(512),
    FILE_PATH       NVARCHAR(512),
    CONTENT         NVARCHAR(max),
    ENCODING        NVARCHAR(64),
    BIN_CONTENT     VARBINARY(max),
    CREATE_USER     NVARCHAR(64),
    CREATE_TIME     DATETIME2,
    UPDATE_USER     NVARCHAR(64),
    UPDATE_TIME     DATETIME2,
    PRIMARY KEY (ID)
);

IF OBJECT_ID('LC_WF_PARTICIPANT') IS NOT NULL
DROP TABLE LC_WF_PARTICIPANT;
CREATE TABLE LC_WF_PARTICIPANT (
    ID                              NVARCHAR(64)     NOT NULL  ,
    WORKITEM_ID                     BIGINT                ,
    WORKITEM_NAME                   NVARCHAR(256)              ,
    PROCESS_DEF_ID                  BIGINT           ,
    PROCESSINST_ID                  BIGINT                ,
    PROCESSINST_NAME                NVARCHAR(256)              ,
    PROCESS_DEF_NAME                NVARCHAR(256)              ,
    PROCESS_CH_NAME                 NVARCHAR(256)              ,
    ACTIVITY_DEF_ID                 NVARCHAR(64)               ,
    CURRENT_STATE                   INT                       ,
    BIZ_STATE                       NVARCHAR(64)               ,
    SYS_FLOW_CURR_ACTIVITYINSTNAME  NVARCHAR(256)              ,
    SYS_FLOW_CURR_ACTIVITYINSTID    BIGINT                ,
    SYS_FLOW_CURREMPLD              NVARCHAR(20)               ,
    SYS_FLOW_CURR_ORGIDS            NVARCHAR(1024)              ,
    SYS_FLOW_CURR_TIMES             DATETIME2                  ,
    SYS_FLOW_START_EMPLD            NVARCHAR(256)              ,
    SYS_FLOW_START_ORGLD            NVARCHAR(64)               ,
    SYS_FLOW_START_TIME             DATETIME2                  ,
    BPS_TENANT_ID                   NVARCHAR(64)               ,
    TENANT_ID                       NVARCHAR(64)               ,
    ENTITY_NAME                     NVARCHAR(256)              ,
    ENTITY_PRIMARY_VALUE            NVARCHAR(1024)             ,
    PRIMARY KEY (ID)
);

IF OBJECT_ID('LC_WF_PROCESSINST') IS NOT NULL
DROP TABLE LC_WF_PROCESSINST;
CREATE TABLE LC_WF_PROCESSINST (
    ID                              NVARCHAR(64)     NOT NULL  ,
    PROCESS_DEF_ID                  DECIMAL(20, 0)            ,
    PROCESS_INST_ID                  DECIMAL(20, 0)            ,
    PROCESS_INST_NAME                NVARCHAR(256)              ,
    PROCESS_DEF_NAME                NVARCHAR(256)              ,
    PROCESS_CH_NAME                 NVARCHAR(256)              ,
    CURRENT_STATE                   int                       ,
    BPS_TENANT_ID                   NVARCHAR(64)               ,
    APP_NAME						NVARCHAR(64)               ,
    TENANT_ID                       NVARCHAR(64)               ,
    ENTITY_NAME                     NVARCHAR(256)              ,
    ENTITY_PRIMARY_VALUE            NVARCHAR(1024)             ,
    EXTEND							NVARCHAR(1024)			  ,
    PRIMARY KEY (ID)
);
