
/*==============================================================*/
/* Table: LC_CONTRIBUTION                                   */
/*==============================================================*/
DROP TABLE IF EXISTS LC_CONTRIBUTION;
CREATE TABLE LC_CONTRIBUTION  (
  ID                         VARCHAR(64)        NOT NULL ,
  CODE                       VARCHAR(256)    ,
  NAME                       VARCHAR(256)     ,
  CATEGORY                   VARCHAR(64)    ,
  APP_NAME			      	 VARCHAR(64)          ,
  DESCRIPTION                TEXT           ,
  EXTEND                     TEXT           ,
  DEL_FLAG                   CHAR           ,
  CREATE_USER                VARCHAR(64)    ,
  CREATE_TIME                TIMESTAMP      ,
  UPDATE_USER                VARCHAR(64)    ,
  UPDATE_TIME                TIMESTAMP      ,
  TENANT_ID                  VARCHAR(64)    ,
  ONLINE_TYPE                VARCHAR(64)    ,
  BI_FOLDER                  VARCHAR(64)    ,
  PRIMARY KEY (ID)
) ;

/*==============================================================*/
/* Table: LC_RESOURCE                                       */
/*==============================================================*/
DROP TABLE IF EXISTS LC_RESOURCE;
CREATE TABLE LC_RESOURCE  (
  ID                         VARCHAR(64)        NOT NULL ,
  CODE                       VARCHAR(256)      ,
  NAME                       VARCHAR(256)       ,
  RESOURCE_TYPE              VARCHAR(64)     ,
  APP_NAME			      	 VARCHAR(64)           ,
  CONTRIBUTION_ID			 VARCHAR(64)           ,
  DESCRIPTION                TEXT            ,
  MD5                        VARCHAR(512)    ,
  RUNTIME_MD5                VARCHAR(512)   ,
  FILE_PATH                  VARCHAR(512)    ,
  STATUS                     VARCHAR(64)     ,
  CHANGE_VERSION             INT             ,
  EXTEND                     TEXT            ,
  DEL_FLAG                   CHAR            ,
  CREATE_USER                VARCHAR(64)     ,
  CREATE_TIME                TIMESTAMP       ,
  UPDATE_USER                VARCHAR(64)     ,
  UPDATE_TIME                TIMESTAMP       ,
  TENANT_ID                  VARCHAR(64)     ,
  CATEGORY1                  VARCHAR(256)    ,
  CATEGORY2                  VARCHAR(256)    ,
  CATEGORY3                  VARCHAR(256)    ,
  BI_RESOURCE                VARCHAR(256)    ,
  RESOURCE_SUB_TYPE          VARCHAR(256)    ,
  RESOURCE_GROUP_ID          VARCHAR(64)     ,
  PRIMARY KEY (ID)
) ;

/*==============================================================*/
/* Table: LC_RESOURCE_CONTENT                               */
/*==============================================================*/
DROP TABLE IF EXISTS LC_RESOURCE_CONTENT;
CREATE TABLE LC_RESOURCE_CONTENT  (
  ID                         VARCHAR(64)        NOT NULL ,
  CONTRIBUTION_ID			 VARCHAR(64)       ,
  CONTENT                    TEXT    ,
  ENCODING                   VARCHAR(64)      ,
  BIN_CONTENT                TEXT             ,
  EXTEND                     TEXT             ,
  PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: LC_H_RESOURCE_CONTENT                               */
/*==============================================================*/
DROP TABLE IF EXISTS LC_H_RESOURCE_CONTENT;
CREATE TABLE LC_H_RESOURCE_CONTENT  (
  ID                         VARCHAR(64)        NOT NULL  ,
  RESOURCE_ID    	      	 VARCHAR(64)  ,
  CONTRIBUTION_ID			 VARCHAR(64)   ,
  MD5                        VARCHAR(512)  ,
  CONTENT                    TEXT   ,
  ENCODING                   VARCHAR(64)      ,
  BIN_CONTENT                TEXT             ,
  COMMIT_VERSION             VARCHAR(64)  ,
  COMMIT_MESSAGE             VARCHAR(512) ,
  UPDATE_USER                VARCHAR(64)  ,
  UPDATE_TIME                TIMESTAMP  ,
  EXTEND                     TEXT             ,
  PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: LC_RUNTIME_RESOURCE                               */
/*==============================================================*/
DROP TABLE IF EXISTS LC_RUNTIME_RESOURCE;
CREATE TABLE LC_RUNTIME_RESOURCE  (
  ID                         VARCHAR(64)        NOT NULL ,
  RESOURCE_ID    	      	 VARCHAR(64)   ,
  CONTRIBUTION_ID			 VARCHAR(64)  ,
  SOURCE_MD5                 VARCHAR(512)  ,
  FILE_PATH                  VARCHAR(512)  ,
  CONTENT                    TEXT   ,
  ENCODING                   VARCHAR(64)      ,
  BIN_CONTENT                TEXT             ,
  CREATE_USER                VARCHAR(64) ,
  CREATE_TIME                TIMESTAMP  ,
  UPDATE_USER                VARCHAR(64)  ,
  UPDATE_TIME                TIMESTAMP  ,
  PRIMARY KEY (ID)
) ;

/*==============================================================*/
/* Table: LC_R_ENTITY_DATASOURCE                                   */
/*==============================================================*/
drop table if exists LC_R_ENTITY_DATASOURCE;
create table LC_R_ENTITY_DATASOURCE
(
   APP_NAME              varchar(64) not null ,
   DATASOURCE_NAME       varchar(64) not null ,
   ENTITY_NAME_INCLUDES  varchar(512) ,
   ENTITY_NAME_EXCLUDES  varchar(512) ,
   primary key(APP_NAME, DATASOURCE_NAME)
) ;

/*==============================================================*/
/* Table: LC_PROJECT_BASELINE                                   */
/*==============================================================*/
DROP TABLE IF EXISTS LC_PROJECT_BASELINE;
CREATE TABLE LC_PROJECT_BASELINE  (
  ID                        VARCHAR(64)           NOT NULL      ,
  NAME                      VARCHAR(256)                        ,
  CODE                      VARCHAR(256)                        ,
  TAG_NUM                   VARCHAR(64)                         ,
  APP_NAME                VARCHAR(64)                         ,
  IS_USE                    INT                                 ,
  RESOURCE_BASELINE_DATA    TEXT                                ,
  DESCRIPTION               TEXT                                ,
  CREATE_USER               VARCHAR(64)                         ,
  CREATE_TIME               TIMESTAMP                           ,
  UPDATE_USER               VARCHAR(64)                         ,
  UPDATE_TIME               TIMESTAMP                           ,
  TENANT_ID                 VARCHAR(64)                         ,
  PRIMARY KEY (ID)
);

/*==============================================================*/
/* Table: LC_PROJECT_SNAPSHOT                                   */
/*==============================================================*/
DROP TABLE IF EXISTS LC_PROJECT_SNAPSHOT;
CREATE TABLE LC_PROJECT_SNAPSHOT  (
  APP_NAME                        VARCHAR(64)           NOT NULL      ,
  CONTENT                   TEXT                                ,
  PRIMARY KEY (APP_NAME)
);

DROP TABLE IF EXISTS LC_R_RESOURCE_RELATION;
CREATE TABLE LC_R_RESOURCE_RELATION  (
  ID                          VARCHAR(64)       NOT NULL    ,
  SOURCE_CODE                 VARCHAR(512)                  ,
  SOURCE_SUB_ID               VARCHAR(512)                  ,
  SOURCE_TYPE                 VARCHAR(64)                   ,
  SOURCE_CATEGORY             VARCHAR(64)                   ,
  TARGET_CODE                 VARCHAR(512)                  ,
  TARGET_SUB_ID               VARCHAR(512)                  ,
  TARGET_TYPE                 VARCHAR(64)                   ,
  TARGET_CATEGORY             VARCHAR(64)                   ,
  APP_NAME                    VARCHAR(64)                   ,
  PRIMARY KEY (ID)
) ;

DROP TABLE IF EXISTS LC_R_BI_DATASOURCE_RELATION;
CREATE TABLE LC_R_BI_DATASOURCE_RELATION
(
    ID                       VARCHAR(64)        NOT NULL 	   ,
    APP_NAME                 VARCHAR(64)        NOT NULL 	   ,
    DATASOURCE_ID            VARCHAR(64)        NOT NULL 	   ,
    DATASOURCE_NAME          VARCHAR(256)       NOT NULL       ,
    PRIMARY KEY (ID)
);

DROP TABLE IF EXISTS LC_IMPORT_HISTORY;
CREATE TABLE LC_IMPORT_HISTORY  (
  ID                          varchar(64)       NOT NULL        ,
  IMPORT_BASELINE_NAME        varchar(256)                      ,
  IMPORT_BASELINE_NUM         varchar(64)                       ,
  IMPORT_APP_TPL_NAME         varchar(256)                      ,
  IMPORT_APP_TPL_TYPES        varchar(256)                      ,
  APP_NAME                    varchar(256)                      ,
  IMPORT_RESULT               text                              ,
  IMPORT_TYPES                varchar(64)                       ,
  OPERATOR                    varchar(64)                       ,
  CREATE_USER                 varchar(64)                                           ,
  UPDATE_USER                 varchar(64)                                           ,
  CREATE_TIME                 TIMESTAMP                                              ,
  UPDATE_TIME                 TIMESTAMP                                              ,
  TENANT_ID                   varchar(64)                                           ,
  FILE_ID                     varchar(64)                       ,
  PRIMARY KEY (ID)
) ;

DROP TABLE IF EXISTS LC_COMPONENT_GROUP;
CREATE TABLE LC_COMPONENT_GROUP  (
  ID                      VARCHAR(64)           NOT NULL           ,
  NAME                    VARCHAR(256)                             ,
  CODE                    VARCHAR(64)                              ,
  ICON_CODE               VARCHAR(64)                              ,
  SORT_NO                 DECIMAL(2, 0)                            ,
  EXTRA                   TEXT                                     ,
  DESCRIPTION             TEXT                                     ,
  CREATE_TIME             TIMESTAMP                                 ,
  UPDATE_TIME             TIMESTAMP                                 ,
  CREATE_USER             VARCHAR(64)                              ,
  UPDATE_USER             VARCHAR(64)                              ,
  TENANT_ID               VARCHAR(64)                              ,
  APP_NAME                VARCHAR(64)                              ,
  PRIMARY KEY (ID)
) ;

DROP TABLE IF EXISTS LC_COMPONENT;
CREATE TABLE LC_COMPONENT  (
  ID                      VARCHAR(64)            NOT NULL          ,
  NAME                    VARCHAR(256)                             ,
  CODE                    VARCHAR(64)                              ,
  ICON_CODE               VARCHAR(64)                              ,
  SORT_NO                 DECIMAL(2, 0)                            ,
  GROUP_ID                VARCHAR(64)                              ,
  COMPONENT_CENTER_CODE   VARCHAR(64)                              ,
  VERSION                 VARCHAR(64)                              ,
  IS_USE                  INT                                      ,
  CONTENT                 TEXT                                     ,
  EXTRA                   TEXT                                     ,
  DESCRIPTION             TEXT                                     ,
  FILE_ID                 VARCHAR(64)                              ,
  CREATE_TIME             TIMESTAMP                                ,
  UPDATE_TIME             TIMESTAMP                                ,
  CREATE_USER             VARCHAR(64)                              ,
  UPDATE_USER             VARCHAR(64)                              ,
  TENANT_ID               VARCHAR(64)                              ,
  APP_NAME                VARCHAR(64)                              ,
  PRIMARY KEY (ID)
) ;

DROP TABLE IF EXISTS LC_RESOURCE_GROUP;
CREATE TABLE LC_RESOURCE_GROUP  (
  ID                      varchar(64)             NOT NULL         ,
  CODE                    varchar(256)            NOT NULL         ,
  NAME                    varchar(256)                             ,
  APP_NAME                varchar(64)                              ,
  CONTRIBUTION_ID         varchar(64)                              ,
  GROUP_TYPE              varchar(64)                              ,
  SORT_BY                 DECIMAL(2, 0)                            ,
  DESCRIPTION             TEXT                                     ,
  EXTEND                  text                                     ,
  CREATE_USER             varchar(64)                              ,
  CREATE_TIME             TIMESTAMP                                 ,
  UPDATE_USER             varchar(64)                              ,
  UPDATE_TIME             TIMESTAMP                                 ,
  TENANT_ID               varchar(64)                              ,
  PRIMARY KEY (ID)
)  ;

DROP TABLE IF EXISTS LC_PROJECT_BRANCH;
CREATE TABLE LC_PROJECT_BRANCH  (
  ID                      varchar(64)             NOT NULL        ,
  NAME                    varchar(256)                            ,
  CODE                    varchar(64)                             ,
  BRANCH_NUM              varchar(64)                             ,
  APP_NAME                varchar(256)                            ,
  IS_USE                  int                                  ,
  CONTENT                 TEXT                                ,
  DESCRIPTION             TEXT                                    ,
  CREATE_USER             varchar(64)                             ,
  CREATE_TIME             TIMESTAMP                                ,
  UPDATE_USER             varchar(64)                             ,
  UPDATE_TIME             TIMESTAMP                                ,
  TENANT_ID               varchar(64)                             ,
  PRIMARY KEY (ID)
) ;

DROP TABLE IF EXISTS LC_RESOURCE_RECYCLE;
CREATE TABLE LC_RESOURCE_RECYCLE  (
  ID                      varchar(64)             NOT NULL         ,
  RESOURCE_NAME           varchar(256)                             ,
  RESOURCE_CODE           varchar(256)                              ,
  RESOURCE_TYPE           varchar(64)                              ,
  CONTRIBUTION_ID         varchar(64)                              ,
  RESOURCE_JSON           TEXT                                 ,
  DELETE_TIME             TIMESTAMP                                 ,
  DELETE_USER             varchar(64)                              ,
  APP_NAME                varchar(256)                            ,
  PRIMARY KEY (ID)
)  ;

DROP TABLE IF EXISTS LC_RESOURCE_SHARE;
CREATE TABLE LC_RESOURCE_SHARE  (
  ID                      varchar(64)              NOT NULL       ,
  RESOURCE_NAME           varchar(256)                            ,
  RESOURCE_TYPE           varchar(64)                             ,
  RESOURCE_SUB_TYPE       varchar(64)                             ,
  RESOURCE_CODE           varchar(256)                            ,
  SHARE_TYPE              varchar(64)                             ,
  SHARE_RULE              TEXT                                    ,
  APP_NAME                varchar(64)                             ,
  EXTEND                  TEXT                                    ,
  CREATE_USER             varchar(64)                             ,
  CREATE_TIME             TIMESTAMP                               ,
  UPDATE_USER             varchar(64)                             ,
  UPDATE_TIME             TIMESTAMP                               ,
  PRIMARY KEY (ID)
) ;


-- 索引
CREATE INDEX LC_CONTRIBUTION_INDEX ON LC_CONTRIBUTION(APP_NAME, CODE);

CREATE INDEX LC_RESOURCE_INDEX ON LC_RESOURCE(APP_NAME, CONTRIBUTION_ID, CODE);
CREATE INDEX LC_RESOURCE_CONTENT_INDEX ON LC_RESOURCE_CONTENT(CONTRIBUTION_ID);

CREATE INDEX LC_H_RESOURCE_CONTENT_INDEX ON LC_H_RESOURCE_CONTENT(RESOURCE_ID, CONTRIBUTION_ID);

CREATE INDEX LC_RUNTIME_RESOURCE_INDEX ON LC_RUNTIME_RESOURCE(RESOURCE_ID, CONTRIBUTION_ID);

CREATE INDEX LC_BASELINE_APP_NAME_INDEX ON LC_PROJECT_BASELINE(APP_NAME);

DROP TABLE IF EXISTS LC_RESOURCE_BOARD_SORT;
CREATE TABLE LC_RESOURCE_BOARD_SORT (
    RES_SORT_ID         VARCHAR(64)     NOT NULL    ,
    RESOURCE_CODE       VARCHAR(64)                 ,
    VIEW_CODE           VARCHAR(64)                 ,
    USER_CODE           VARCHAR(64)                 ,
    APP_CODE            VARCHAR(64)                 ,
    SORT_JSON           TEXT                        ,
    PRIMARY KEY (RES_SORT_ID)
);

DROP TABLE IF EXISTS LC_RELEASE_RUNTIME_RESOURCE;
CREATE TABLE LC_RELEASE_RUNTIME_RESOURCE  (
  ID                         VARCHAR(64)        NOT NULL ,
  RESOURCE_ID    	      	 VARCHAR(64)   ,
  CONTRIBUTION_ID			 VARCHAR(64)  ,
  SOURCE_MD5                 VARCHAR(512)  ,
  FILE_PATH                  VARCHAR(512)  ,
  CONTENT                    TEXT   ,
  ENCODING                   VARCHAR(64)      ,
  BIN_CONTENT                TEXT             ,
  CREATE_USER                VARCHAR(64) ,
  CREATE_TIME                TIMESTAMP  ,
  UPDATE_USER                VARCHAR(64)  ,
  UPDATE_TIME                TIMESTAMP  ,
  PRIMARY KEY (ID)
) ;

DROP TABLE IF EXISTS LC_WF_PARTICIPANT;
CREATE TABLE LC_WF_PARTICIPANT (
    ID                              varchar(64)     NOT NULL  ,
    WORKITEM_ID                     DECIMAL(20,0)                ,
    WORKITEM_NAME                   varchar(256)              ,
    PROCESS_DEF_ID                  DECIMAL(20,0)                ,
    PROCESSINST_ID                  DECIMAL(20,0)                ,
    PROCESSINST_NAME                varchar(256)              ,
    PROCESS_DEF_NAME                varchar(256)              ,
    PROCESS_CH_NAME                 varchar(256)              ,
    ACTIVITY_DEF_ID                 varchar(64)               ,
    CURRENT_STATE                   int                       ,
    BIZ_STATE                       varchar(64)               ,
    SYS_FLOW_CURR_ACTIVITYINSTNAME  varchar(256)              ,
    SYS_FLOW_CURR_ACTIVITYINSTID    DECIMAL(20,0)                ,
    SYS_FLOW_CURREMPLD              varchar(20)               ,
    SYS_FLOW_CURR_ORGIDS            varchar(1024)               ,
    SYS_FLOW_CURR_TIMES             TIMESTAMP                  ,
    SYS_FLOW_START_EMPLD            varchar(256)              ,
    SYS_FLOW_START_ORGLD            varchar(64)               ,
    SYS_FLOW_START_TIME             TIMESTAMP                  ,
    BPS_TENANT_ID                   varchar(64)               ,
    TENANT_ID                       varchar(64)               ,
    ENTITY_NAME                     varchar(256)              ,
    ENTITY_PRIMARY_VALUE            varchar(1024)             ,
    PRIMARY KEY (ID)
);

DROP TABLE IF EXISTS LC_WF_PROCESSINST;
CREATE TABLE LC_WF_PROCESSINST (
    ID                              varchar(64)     NOT NULL  ,
    PROCESS_DEF_ID                  DECIMAL(20, 0)            ,
    PROCESS_INST_ID                  DECIMAL(20, 0)            ,
    PROCESS_INST_NAME                varchar(256)              ,
    PROCESS_DEF_NAME                varchar(256)              ,
    PROCESS_CH_NAME                 varchar(256)              ,
    CURRENT_STATE                   int                       ,
    BPS_TENANT_ID                   varchar(64)               ,
    APP_NAME						varchar(64)               ,
    TENANT_ID                       varchar(64)               ,
    ENTITY_NAME                     varchar(256)              ,
    ENTITY_PRIMARY_VALUE            varchar(1024)             ,
    EXTEND							varchar(1024)			  ,
    PRIMARY KEY (ID)
);

-- INSERT INTO LC_CONTRIBUTION (ID, CODE, NAME, DESCRIPTION, CATEGORY, APP_NAME, ONLINE_TYPE) VALUES ('default-1', 'com.primeton.gocom.lowcode.demo', 'demo', null, 'online', 'AFCENTER', 'common');
