/*==============================================================*/
/*======================  不兼容记录   ==========================*/
-- 1、
/*==============================================================*/
/*==============================================================*/
-- 示例  2022-x-x
-- 添加字段：ALTER TABLE EXAMPLE ADD COLUMN NEW_FIELD2 VARCHAR(256)   comment '字段说明';
-- 修改字段类型：ALTER TABLE EXAMPLE MODIFY COLUMN NEW_FIELD2 VARCHAR(512);
-- 修改字段名称： ALTER TABLE EXAMPLE CHANGE COLUMN NEW_FIELD2 NEW_FIELD3 VARCHAR(512);
-- 删除字段： ALTER TABLE EXAMPLE DROP NEW_FIELD2;

-- 2022-09-19 新增lc_r_resource_relation资源关联关系表
DROP TABLE IF EXISTS LC_R_RESOURCE_RELATION;
CREATE TABLE LC_R_RESOURCE_RELATION  (
  ID                          VARCHAR(64)       NOT NULL    COMMENT 'ID',
  SOURCE_ID                   VARCHAR(512)                  COMMENT '源模型标识',
  SOURCE_CODE                 VARCHAR(512)                  COMMENT '源模型编码',
  SOURCE_SUB_ID               VARCHAR(512)                  COMMENT '源模型次级标识(主要给实体用)',
  SOURCE_TYPE                 VARCHAR(64)                   COMMENT '源模型类型',
  SOURCE_CATEGORY             VARCHAR(64)                   COMMENT '源资源种类：在线还是离线',
  TARGET_ID                   VARCHAR(512)                  COMMENT '目标模型标识',
  TARGET_CODE                 VARCHAR(512)                  COMMENT '目标模型qname(离线资源)',
  TARGET_SUB_ID               VARCHAR(512)                  COMMENT '目标模型次级标识',
  TARGET_TYPE                 VARCHAR(64)                   COMMENT '目标模型类型',
  TARGET_CATEGORY             VARCHAR(64)                   COMMENT '目标源种类：在线还是离线',
  PRIMARY KEY (ID),
  INDEX AFC_LC_SOURCE_INDEX(SOURCE_ID),
  INDEX AFC_LC_TARGET_INDEX(TARGET_ID)
) COMMENT = '资源关系表';

-- 2022-09-28 新增resource、content字段做扩展逻辑
ALTER TABLE LC_RESOURCE ADD COLUMN CATEGORY1 VARCHAR(256)  comment '资源类型1';
ALTER TABLE LC_RESOURCE ADD COLUMN CATEGORY2 VARCHAR(256)  comment '资源类型2';
ALTER TABLE LC_RESOURCE ADD COLUMN CATEGORY3 VARCHAR(256)  comment '资源类型3';
ALTER TABLE LC_RESOURCE_CONTENT ADD COLUMN EXTEND TEXT  comment '扩展信息';
ALTER TABLE LC_H_RESOURCE_CONTENT ADD COLUMN EXTEND TEXT  comment '扩展信息';

-- 2022-10-10 新增contribution字段做在线构件包类型
ALTER TABLE LC_CONTRIBUTION ADD COLUMN ONLINE_TYPE VARCHAR(64) comment '在线构件包类型:通用、报表等';
UPDATE LC_CONTRIBUTION SET ONLINE_TYPE='common' WHERE CATEGORY='online';
ALTER TABLE LC_RESOURCE ADD COLUMN BI_RESOURCE VARCHAR(256) comment '映射BI资源路径';

-- 2022-10-25 新增resource字段做在线资源次级类型
ALTER TABLE LC_RESOURCE ADD COLUMN RESOURCE_SUB_TYPE VARCHAR(256)  comment '资源二级类型';

-- 恢复数据实体数据源关联表 2022-11-19
create table LC_R_ENTITY_DATASOURCE
(
   APP_NAME              varchar(64) not null comment '应用名称',
   DATASOURCE_NAME       varchar(64) not null comment '数据源名称',
   ENTITY_NAME_INCLUDES  varchar(512) comment '包含的实体名称，多个逗号分隔，支持统配',
   ENTITY_NAME_EXCLUDES  varchar(512) comment '排除的实体名称，多个逗号分隔，支持统配',
   primary key(APP_NAME, DATASOURCE_NAME)
) comment='数据实体和数据源的关联关系表';

-- 结束；
