/*==============================================================*/
/*======================  不兼容记录   ==========================*/
-- 1、
/*==============================================================*/
/*==============================================================*/
-- 示例  2022-x-x
-- 添加字段：ALTER TABLE EXAMPLE ADD COLUMN NEW_FIELD2 VARCHAR(256)   comment '字段说明';
-- 修改字段类型：ALTER TABLE EXAMPLE MODIFY COLUMN NEW_FIELD2 VARCHAR(512);
-- 修改字段名称： ALTER TABLE EXAMPLE CHANGE COLUMN NEW_FIELD2 NEW_FIELD3 VARCHAR(512);
-- 删除字段： ALTER TABLE EXAMPLE DROP NEW_FIELD2;


-- 2024-11-11 增加runtime资源发布表
DROP TABLE IF EXISTS LC_RELEASE_RUNTIME_RESOURCE;
CREATE TABLE LC_RELEASE_RUNTIME_RESOURCE  (
  ID                    varchar(64)               NOT NULL            COMMENT '主键',
  RESOURCE_ID           varchar(256)                                  COMMENT '资源id',
  CONTRIBUTION_ID       varchar(256)                                  COMMENT '所属构件包ID',
  SOURCE_MD5            varchar(512)                                  COMMENT '源资源内容摘要',
  FILE_PATH             varchar(512)                                  COMMENT '文件路径',
  CONTENT               longtext                                      COMMENT '内容',
  ENCODING              varchar(64)                                   COMMENT '编码',
  BIN_CONTENT           longblob                                      COMMENT '二进制文件内容',
  CREATE_USER           varchar(64)                                   COMMENT '创建人',
  CREATE_TIME           datetime                                      COMMENT '创建时间',
  UPDATE_USER           varchar(64)                                   COMMENT '更新人',
  UPDATE_TIME           datetime                                      COMMENT '更新时间',
  PRIMARY KEY (ID)
) COMMENT='低开运行时发布资源';

DROP TABLE IF EXISTS LC_WF_PARTICIPANT;
CREATE TABLE LC_WF_PARTICIPANT (
    ID                              varchar(64)     NOT NULL    COMMENT '主键',
    WORKITEM_ID                     bigint(20)                  COMMENT '工作项ID',
    WORKITEM_NAME                   varchar(256)                COMMENT '工作项NAME',
    PROCESS_DEF_ID                  bigint(20)                  COMMENT '流程定义ID',
    PROCESS_INST_ID                  bigint(20)                  COMMENT '流程实例ID',
    PROCESS_INST_NAME                varchar(256)                COMMENT '流程实例名称',
    PROCESS_DEF_NAME                varchar(256)                COMMENT '流程定义名称',
    PROCESS_CH_NAME                 varchar(256)                COMMENT '流程定义显示名称',
    ACTIVITY_DEF_ID                 varchar(64)                 COMMENT '活动定义ID',
    CURRENT_STATE                   int(20)                     COMMENT '工作项当前状态',
    BIZ_STATE                       varchar(64)                 COMMENT '操作动作状态',
    SYS_FLOW_CURR_ACTIVITYINSTNAME  varchar(256)                COMMENT '活动实例名称',
    SYS_FLOW_CURR_ACTIVITYINSTID    bigint(20)                  COMMENT '活动实例ID',
    SYS_FLOW_CURREMPLD              varchar(20)                 COMMENT '参与者',
    SYS_FLOW_CURR_ORGIDS            varchar(1024)               COMMENT '参与者所在机构，id逗号隔开',
    SYS_FLOW_CURR_TIMES             datetime                    COMMENT '活动到达时间',
    SYS_FLOW_START_EMPLD            varchar(256)                COMMENT '流程启动者ID',
    SYS_FLOW_START_ORGLD            varchar(64)                 COMMENT '发起人机构',
    SYS_FLOW_START_TIME             datetime                    COMMENT '流程发起时间',
    BPS_TENANT_ID                   varchar(64)                 COMMENT 'BPS租户ID',
    TENANT_ID                       varchar(64)                 COMMENT '租户ID',
    ENTITY_NAME                     varchar(256)                COMMENT '业务实体名称',
    ENTITY_PRIMARY_VALUE            varchar(1024)               COMMENT '业务表主键值',
    PRIMARY KEY (ID)
) COMMENT='业务流程权限关系表';

DROP TABLE IF EXISTS LC_WF_PROCESSINST;
CREATE TABLE LC_WF_PROCESSINST (
    ID                              varchar(64)     NOT NULL  COMMENT '主键',
    PROCESS_DEF_ID                  DECIMAL(20, 0)            COMMENT '流程定义id' ,
    PROCESSINST_ID                  DECIMAL(20, 0)            COMMENT '流程实例id',
    PROCESSINST_NAME                varchar(256)              COMMENT '流程实例名称',
    PROCESS_DEF_NAME                varchar(256)              COMMENT '流程定义名称',
    PROCESS_CH_NAME                 varchar(256)              COMMENT '流程显示名称',
    CURRENT_STATE                   int                       COMMENT '流程状态',
    BPS_TENANT_ID                   varchar(64)               COMMENT 'bps租户id',
    APP_NAME						varchar(64)               COMMENT '应用code',
    TENANT_ID                       varchar(64)               COMMENT 'afc租户id',
    ENTITY_NAME                     varchar(256)              COMMENT '流程主实体名称',
    ENTITY_PRIMARY_VALUE            varchar(1024)             COMMENT '流程主实体业务主键值',
    EXTEND							varchar(1024)			  COMMENT '扩展字段',
    PRIMARY KEY (ID)
) COMMENT='业务流程状态关系表';