/*******************************************************************************
 *
 * Copyright (c) 2001-2006 Primeton Technologies, Ltd.
 * All rights reserved.
 *
 * Created on Apr 11, 2008
 *******************************************************************************/
package com.primeton.eos.project.model.customerdataset;

import com.eos.data.sdo.IObjectFactory;
import com.primeton.ext.data.sdo.IllegalDataObjectTypeException;
import commonj.sdo.DataObject;
import commonj.sdo.Type;
import commonj.sdo.helper.DataFactory;
import commonj.sdo.helper.TypeHelper;
import java.util.Date;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>DemoCustomer</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link com.primeton.eos.project.model.customerdataset.DemoCustomer#getId <em>Id</em> <desc></desc>}</li>
 *   <li>{@link com.primeton.eos.project.model.customerdataset.DemoCustomer#getCustomerName <em>CustomerName</em> <desc>客户名称</desc>}</li>
 *   <li>{@link com.primeton.eos.project.model.customerdataset.DemoCustomer#getCustomerCode <em>CustomerCode</em> <desc>客户代码</desc>}</li>
 *   <li>{@link com.primeton.eos.project.model.customerdataset.DemoCustomer#getCredType <em>CredType</em> <desc>证件类型</desc>}</li>
 *   <li>{@link com.primeton.eos.project.model.customerdataset.DemoCustomer#getCredNo <em>CredNo</em> <desc>证件号码</desc>}</li>
 *   <li>{@link com.primeton.eos.project.model.customerdataset.DemoCustomer#getCustomerPhone <em>CustomerPhone</em> <desc>客户电话</desc>}</li>
 *   <li>{@link com.primeton.eos.project.model.customerdataset.DemoCustomer#getCustomerAddress <em>CustomerAddress</em> <desc>客户地址</desc>}</li>
 *   <li>{@link com.primeton.eos.project.model.customerdataset.DemoCustomer#getRemark <em>Remark</em> <desc>备注</desc>}</li>
 *   <li>{@link com.primeton.eos.project.model.customerdataset.DemoCustomer#getCreateUser <em>CreateUser</em> <desc>创建人</desc>}</li>
 *   <li>{@link com.primeton.eos.project.model.customerdataset.DemoCustomer#getCreateTime <em>CreateTime</em> <desc>创建时间</desc>}</li>
 *   <li>{@link com.primeton.eos.project.model.customerdataset.DemoCustomer#getUpdateUser <em>UpdateUser</em> <desc>更新人</desc>}</li>
 *   <li>{@link com.primeton.eos.project.model.customerdataset.DemoCustomer#getUpdateTime <em>UpdateTime</em> <desc>更新时间</desc>}</li>
 * </ul>
 * </p>
 *
 * @extends DataObject;
 */
public interface DemoCustomer extends DataObject {

	public String QNAME = "com.primeton.eos.project.model.customerdataset.DemoCustomer";

	public Type TYPE = TypeHelper.INSTANCE.getType("com.primeton.eos.project.model.customerdataset", "DemoCustomer");
	
    public static String id = "id";
    public static String customerName = "customerName";
    public static String customerCode = "customerCode";
    public static String credType = "credType";
    public static String credNo = "credNo";
    public static String customerPhone = "customerPhone";
    public static String customerAddress = "customerAddress";
    public static String remark = "remark";
    public static String createUser = "createUser";
    public static String createTime = "createTime";
    public static String updateUser = "updateUser";
    public static String updateTime = "updateTime";

	public static final IObjectFactory<DemoCustomer> FACTORY = new IObjectFactory<DemoCustomer>() {
		public DemoCustomer create() {
            Type type = TYPE;
			if(type == null) {
				type = TypeHelper.INSTANCE.getType("com.primeton.eos.project.model.customerdataset", "DemoCustomer");
			}
			if(type == null) {
				throw new IllegalDataObjectTypeException("cannot find entity type: " + QNAME);	
			}
			return (DemoCustomer) DataFactory.INSTANCE.create(type);
		}
	};

	/**
	 * Returns the value of the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Id</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Id</em>' attribute.
	 * @see #setId(int)
	 */
	public int getId();

	/**
	 * Sets the value of the '{@link com.primeton.eos.project.model.customerdataset.DemoCustomer#getId <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Id</em>' attribute.
	 * @see #getId()
	 */
	public void setId(int id);

	/**
	 * Returns the value of the '<em><b>CustomerName</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>CustomerName</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>CustomerName</em>' attribute.
	 * @see #setCustomerName(java.lang.String)
	 */
	public String getCustomerName();

	/**
	 * Sets the value of the '{@link com.primeton.eos.project.model.customerdataset.DemoCustomer#getCustomerName <em>CustomerName</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>CustomerName</em>' attribute.
	 * @see #getCustomerName()
	 */
	public void setCustomerName(String customerName);

	/**
	 * Returns the value of the '<em><b>CustomerCode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>CustomerCode</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>CustomerCode</em>' attribute.
	 * @see #setCustomerCode(java.lang.String)
	 */
	public String getCustomerCode();

	/**
	 * Sets the value of the '{@link com.primeton.eos.project.model.customerdataset.DemoCustomer#getCustomerCode <em>CustomerCode</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>CustomerCode</em>' attribute.
	 * @see #getCustomerCode()
	 */
	public void setCustomerCode(String customerCode);

	/**
	 * Returns the value of the '<em><b>CredType</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>CredType</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>CredType</em>' attribute.
	 * @see #setCredType(java.lang.String)
	 */
	public String getCredType();

	/**
	 * Sets the value of the '{@link com.primeton.eos.project.model.customerdataset.DemoCustomer#getCredType <em>CredType</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>CredType</em>' attribute.
	 * @see #getCredType()
	 */
	public void setCredType(String credType);

	/**
	 * Returns the value of the '<em><b>CredNo</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>CredNo</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>CredNo</em>' attribute.
	 * @see #setCredNo(java.lang.String)
	 */
	public String getCredNo();

	/**
	 * Sets the value of the '{@link com.primeton.eos.project.model.customerdataset.DemoCustomer#getCredNo <em>CredNo</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>CredNo</em>' attribute.
	 * @see #getCredNo()
	 */
	public void setCredNo(String credNo);

	/**
	 * Returns the value of the '<em><b>CustomerPhone</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>CustomerPhone</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>CustomerPhone</em>' attribute.
	 * @see #setCustomerPhone(java.lang.String)
	 */
	public String getCustomerPhone();

	/**
	 * Sets the value of the '{@link com.primeton.eos.project.model.customerdataset.DemoCustomer#getCustomerPhone <em>CustomerPhone</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>CustomerPhone</em>' attribute.
	 * @see #getCustomerPhone()
	 */
	public void setCustomerPhone(String customerPhone);

	/**
	 * Returns the value of the '<em><b>CustomerAddress</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>CustomerAddress</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>CustomerAddress</em>' attribute.
	 * @see #setCustomerAddress(java.lang.String)
	 */
	public String getCustomerAddress();

	/**
	 * Sets the value of the '{@link com.primeton.eos.project.model.customerdataset.DemoCustomer#getCustomerAddress <em>CustomerAddress</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>CustomerAddress</em>' attribute.
	 * @see #getCustomerAddress()
	 */
	public void setCustomerAddress(String customerAddress);

	/**
	 * Returns the value of the '<em><b>Remark</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Remark</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Remark</em>' attribute.
	 * @see #setRemark(java.lang.String)
	 */
	public String getRemark();

	/**
	 * Sets the value of the '{@link com.primeton.eos.project.model.customerdataset.DemoCustomer#getRemark <em>Remark</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Remark</em>' attribute.
	 * @see #getRemark()
	 */
	public void setRemark(String remark);

	/**
	 * Returns the value of the '<em><b>CreateUser</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>CreateUser</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>CreateUser</em>' attribute.
	 * @see #setCreateUser(java.lang.String)
	 */
	public String getCreateUser();

	/**
	 * Sets the value of the '{@link com.primeton.eos.project.model.customerdataset.DemoCustomer#getCreateUser <em>CreateUser</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>CreateUser</em>' attribute.
	 * @see #getCreateUser()
	 */
	public void setCreateUser(String createUser);

	/**
	 * Returns the value of the '<em><b>CreateTime</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>CreateTime</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>CreateTime</em>' attribute.
	 * @see #setCreateTime(java.util.Date)
	 */
	public Date getCreateTime();

	/**
	 * Sets the value of the '{@link com.primeton.eos.project.model.customerdataset.DemoCustomer#getCreateTime <em>CreateTime</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>CreateTime</em>' attribute.
	 * @see #getCreateTime()
	 */
	public void setCreateTime(Date createTime);

	/**
	 * Returns the value of the '<em><b>UpdateUser</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>UpdateUser</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>UpdateUser</em>' attribute.
	 * @see #setUpdateUser(java.lang.String)
	 */
	public String getUpdateUser();

	/**
	 * Sets the value of the '{@link com.primeton.eos.project.model.customerdataset.DemoCustomer#getUpdateUser <em>UpdateUser</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>UpdateUser</em>' attribute.
	 * @see #getUpdateUser()
	 */
	public void setUpdateUser(String updateUser);

	/**
	 * Returns the value of the '<em><b>UpdateTime</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>UpdateTime</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>UpdateTime</em>' attribute.
	 * @see #setUpdateTime(java.util.Date)
	 */
	public Date getUpdateTime();

	/**
	 * Sets the value of the '{@link com.primeton.eos.project.model.customerdataset.DemoCustomer#getUpdateTime <em>UpdateTime</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>UpdateTime</em>' attribute.
	 * @see #getUpdateTime()
	 */
	public void setUpdateTime(Date updateTime);


}