/*******************************************************************************
 *
 * Copyright (c) 2001-2006 Primeton Technologies, Ltd.
 * All rights reserved.
 *
 * Created on Apr 11, 2008
 *******************************************************************************/
package com.primeton.eos.project.model.customerdataset.impl;

import com.primeton.eos.project.model.customerdataset.DemoCustomer;
import com.primeton.ext.data.sdo.DataUtil;
import com.primeton.ext.data.sdo.ExtendedDataObjectImpl;
import commonj.sdo.Type;
import java.util.Date;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>DemoCustomerImpl</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link com.primeton.eos.project.model.customerdataset.impl.DemoCustomerImpl#getId <em>Id</em> <desc></desc>}</li>
 *   <li>{@link com.primeton.eos.project.model.customerdataset.impl.DemoCustomerImpl#getCustomerName <em>CustomerName</em> <desc>客户名称</desc>}</li>
 *   <li>{@link com.primeton.eos.project.model.customerdataset.impl.DemoCustomerImpl#getCustomerCode <em>CustomerCode</em> <desc>客户代码</desc>}</li>
 *   <li>{@link com.primeton.eos.project.model.customerdataset.impl.DemoCustomerImpl#getCredType <em>CredType</em> <desc>证件类型</desc>}</li>
 *   <li>{@link com.primeton.eos.project.model.customerdataset.impl.DemoCustomerImpl#getCredNo <em>CredNo</em> <desc>证件号码</desc>}</li>
 *   <li>{@link com.primeton.eos.project.model.customerdataset.impl.DemoCustomerImpl#getCustomerPhone <em>CustomerPhone</em> <desc>客户电话</desc>}</li>
 *   <li>{@link com.primeton.eos.project.model.customerdataset.impl.DemoCustomerImpl#getCustomerAddress <em>CustomerAddress</em> <desc>客户地址</desc>}</li>
 *   <li>{@link com.primeton.eos.project.model.customerdataset.impl.DemoCustomerImpl#getRemark <em>Remark</em> <desc>备注</desc>}</li>
 *   <li>{@link com.primeton.eos.project.model.customerdataset.impl.DemoCustomerImpl#getCreateUser <em>CreateUser</em> <desc>创建人</desc>}</li>
 *   <li>{@link com.primeton.eos.project.model.customerdataset.impl.DemoCustomerImpl#getCreateTime <em>CreateTime</em> <desc>创建时间</desc>}</li>
 *   <li>{@link com.primeton.eos.project.model.customerdataset.impl.DemoCustomerImpl#getUpdateUser <em>UpdateUser</em> <desc>更新人</desc>}</li>
 *   <li>{@link com.primeton.eos.project.model.customerdataset.impl.DemoCustomerImpl#getUpdateTime <em>UpdateTime</em> <desc>更新时间</desc>}</li>
 * </ul>
 * </p>
 *
 * @extends ExtendedDataObjectImpl;
 *
 * @implements DemoCustomer;
 */

public class DemoCustomerImpl extends ExtendedDataObjectImpl implements DemoCustomer {
	/**
	 * Comment for <code>serialVersionUID</code>
	 */
	private static final long serialVersionUID = 1L;

	public final static int INDEX_ID = 0;
	public final static int INDEX_CUSTOMERNAME = 1;
	public final static int INDEX_CUSTOMERCODE = 2;
	public final static int INDEX_CREDTYPE = 3;
	public final static int INDEX_CREDNO = 4;
	public final static int INDEX_CUSTOMERPHONE = 5;
	public final static int INDEX_CUSTOMERADDRESS = 6;
	public final static int INDEX_REMARK = 7;
	public final static int INDEX_CREATEUSER = 8;
	public final static int INDEX_CREATETIME = 9;
	public final static int INDEX_UPDATEUSER = 10;
	public final static int INDEX_UPDATETIME = 11;
	public static final int SDO_PROPERTY_COUNT = 12;

	public static final int EXTENDED_PROPERTY_COUNT = -1;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public DemoCustomerImpl() {
		this(TYPE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	public DemoCustomerImpl(Type type) {
		super(type);
	}

	protected void validate() {
		validateType(TYPE);
	}

	/**
	 * Returns the value of the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Id</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Id</em>' attribute.
	 * @see #setId(int)
	 */
	public int getId() {
		return DataUtil.toInt(super.getByIndex(INDEX_ID, true));
	}

	/**
	 * Sets the value of the '{@link com.primeton.eos.Test#getId <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Id</em>' attribute.
	 * @see #getId()
	 */
	public void setId(int id) {
		super.setByIndex(INDEX_ID, id);
	}

	/**
	 * Returns the value of the '<em><b>CustomerName</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>CustomerName</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>CustomerName</em>' attribute.
	 * @see #setCustomerName(java.lang.String)
	 */
	public String getCustomerName() {
		return DataUtil.toString(super.getByIndex(INDEX_CUSTOMERNAME, true));
	}

	/**
	 * Sets the value of the '{@link com.primeton.eos.Test#getCustomerName <em>CustomerName</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>CustomerName</em>' attribute.
	 * @see #getCustomerName()
	 */
	public void setCustomerName(String customerName) {
		super.setByIndex(INDEX_CUSTOMERNAME, customerName);
	}

	/**
	 * Returns the value of the '<em><b>CustomerCode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>CustomerCode</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>CustomerCode</em>' attribute.
	 * @see #setCustomerCode(java.lang.String)
	 */
	public String getCustomerCode() {
		return DataUtil.toString(super.getByIndex(INDEX_CUSTOMERCODE, true));
	}

	/**
	 * Sets the value of the '{@link com.primeton.eos.Test#getCustomerCode <em>CustomerCode</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>CustomerCode</em>' attribute.
	 * @see #getCustomerCode()
	 */
	public void setCustomerCode(String customerCode) {
		super.setByIndex(INDEX_CUSTOMERCODE, customerCode);
	}

	/**
	 * Returns the value of the '<em><b>CredType</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>CredType</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>CredType</em>' attribute.
	 * @see #setCredType(java.lang.String)
	 */
	public String getCredType() {
		return DataUtil.toString(super.getByIndex(INDEX_CREDTYPE, true));
	}

	/**
	 * Sets the value of the '{@link com.primeton.eos.Test#getCredType <em>CredType</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>CredType</em>' attribute.
	 * @see #getCredType()
	 */
	public void setCredType(String credType) {
		super.setByIndex(INDEX_CREDTYPE, credType);
	}

	/**
	 * Returns the value of the '<em><b>CredNo</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>CredNo</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>CredNo</em>' attribute.
	 * @see #setCredNo(java.lang.String)
	 */
	public String getCredNo() {
		return DataUtil.toString(super.getByIndex(INDEX_CREDNO, true));
	}

	/**
	 * Sets the value of the '{@link com.primeton.eos.Test#getCredNo <em>CredNo</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>CredNo</em>' attribute.
	 * @see #getCredNo()
	 */
	public void setCredNo(String credNo) {
		super.setByIndex(INDEX_CREDNO, credNo);
	}

	/**
	 * Returns the value of the '<em><b>CustomerPhone</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>CustomerPhone</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>CustomerPhone</em>' attribute.
	 * @see #setCustomerPhone(java.lang.String)
	 */
	public String getCustomerPhone() {
		return DataUtil.toString(super.getByIndex(INDEX_CUSTOMERPHONE, true));
	}

	/**
	 * Sets the value of the '{@link com.primeton.eos.Test#getCustomerPhone <em>CustomerPhone</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>CustomerPhone</em>' attribute.
	 * @see #getCustomerPhone()
	 */
	public void setCustomerPhone(String customerPhone) {
		super.setByIndex(INDEX_CUSTOMERPHONE, customerPhone);
	}

	/**
	 * Returns the value of the '<em><b>CustomerAddress</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>CustomerAddress</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>CustomerAddress</em>' attribute.
	 * @see #setCustomerAddress(java.lang.String)
	 */
	public String getCustomerAddress() {
		return DataUtil.toString(super.getByIndex(INDEX_CUSTOMERADDRESS, true));
	}

	/**
	 * Sets the value of the '{@link com.primeton.eos.Test#getCustomerAddress <em>CustomerAddress</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>CustomerAddress</em>' attribute.
	 * @see #getCustomerAddress()
	 */
	public void setCustomerAddress(String customerAddress) {
		super.setByIndex(INDEX_CUSTOMERADDRESS, customerAddress);
	}

	/**
	 * Returns the value of the '<em><b>Remark</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Remark</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Remark</em>' attribute.
	 * @see #setRemark(java.lang.String)
	 */
	public String getRemark() {
		return DataUtil.toString(super.getByIndex(INDEX_REMARK, true));
	}

	/**
	 * Sets the value of the '{@link com.primeton.eos.Test#getRemark <em>Remark</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Remark</em>' attribute.
	 * @see #getRemark()
	 */
	public void setRemark(String remark) {
		super.setByIndex(INDEX_REMARK, remark);
	}

	/**
	 * Returns the value of the '<em><b>CreateUser</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>CreateUser</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>CreateUser</em>' attribute.
	 * @see #setCreateUser(java.lang.String)
	 */
	public String getCreateUser() {
		return DataUtil.toString(super.getByIndex(INDEX_CREATEUSER, true));
	}

	/**
	 * Sets the value of the '{@link com.primeton.eos.Test#getCreateUser <em>CreateUser</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>CreateUser</em>' attribute.
	 * @see #getCreateUser()
	 */
	public void setCreateUser(String createUser) {
		super.setByIndex(INDEX_CREATEUSER, createUser);
	}

	/**
	 * Returns the value of the '<em><b>CreateTime</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>CreateTime</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>CreateTime</em>' attribute.
	 * @see #setCreateTime(java.util.Date)
	 */
	public Date getCreateTime() {
		return DataUtil.toDate(super.getByIndex(INDEX_CREATETIME, true));
	}

	/**
	 * Sets the value of the '{@link com.primeton.eos.Test#getCreateTime <em>CreateTime</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>CreateTime</em>' attribute.
	 * @see #getCreateTime()
	 */
	public void setCreateTime(Date createTime) {
		super.setByIndex(INDEX_CREATETIME, createTime);
	}

	/**
	 * Returns the value of the '<em><b>UpdateUser</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>UpdateUser</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>UpdateUser</em>' attribute.
	 * @see #setUpdateUser(java.lang.String)
	 */
	public String getUpdateUser() {
		return DataUtil.toString(super.getByIndex(INDEX_UPDATEUSER, true));
	}

	/**
	 * Sets the value of the '{@link com.primeton.eos.Test#getUpdateUser <em>UpdateUser</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>UpdateUser</em>' attribute.
	 * @see #getUpdateUser()
	 */
	public void setUpdateUser(String updateUser) {
		super.setByIndex(INDEX_UPDATEUSER, updateUser);
	}

	/**
	 * Returns the value of the '<em><b>UpdateTime</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>UpdateTime</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>UpdateTime</em>' attribute.
	 * @see #setUpdateTime(java.util.Date)
	 */
	public Date getUpdateTime() {
		return DataUtil.toDate(super.getByIndex(INDEX_UPDATETIME, true));
	}

	/**
	 * Sets the value of the '{@link com.primeton.eos.Test#getUpdateTime <em>UpdateTime</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>UpdateTime</em>' attribute.
	 * @see #getUpdateTime()
	 */
	public void setUpdateTime(Date updateTime) {
		super.setByIndex(INDEX_UPDATETIME, updateTime);
	}


}