    DROP TABLE IF EXISTS EOS_DICT_ENTRY;

    DROP TABLE IF EXISTS EOS_DICT_TYPE;

    DROP TABLE IF EXISTS EOS_DICT_ENTRY_I18N;

    DROP TABLE IF EXISTS EOS_DICT_TYPE_I18N;

    CREATE TABLE EOS_DICT_ENTRY (
        DICTTYPEID VARCHAR(128) NOT NULL,
        DICTID VARCHAR(128) NOT NULL,
        TENANT_ID VARCHAR(64) NOT NULL,
        DICTNAME VARCHAR(255) NULL,
        STATUS INT NULL,
        SORTNO INT NULL,
        RANK INT NULL,
        PARENTID VARCHAR(255) NULL,
        SEQNO VARCHAR(255) NULL,
        FILTER1 VARCHAR(255) NULL,
        FILTER2 VARCHAR(255) NULL,
        PRIMARY KEY (DICTTYPEID, DICTID,TENANT_ID)
    );

    CREATE TABLE EOS_DICT_TYPE (
        DICTTYPEID VARCHAR(128) NOT NULL,
        TENANT_ID VARCHAR(64) NOT NULL,
        DICTTYPENAME VARCHAR(255) NULL,
        RANK INT NULL,
        PARENTID VARCHAR(255) NULL,
        SEQNO VARCHAR(255) NULL,
        PRIMARY KEY (DICTTYPEID,TENANT_ID)
    );

	CREATE TABLE EOS_DICT_ENTRY_I18N
	(
	  DICTTYPEID  VARCHAR(128 ) NOT NULL,
	  DICTID      VARCHAR(128 ) NOT NULL,
	  DICTNAME    VARCHAR(255 ),
	  LOCALE      VARCHAR(10 )  NOT NULL,
	  TENANT_ID VARCHAR(64) NOT NULL,
	  PRIMARY KEY (DICTTYPEID, DICTID, LOCALE,TENANT_ID)
	);
	
	CREATE TABLE EOS_DICT_TYPE_I18N
	(
	  DICTTYPEID    VARCHAR(128)              NOT NULL,
	  DICTTYPENAME  VARCHAR(255),
	  LOCALE        VARCHAR(10)               NOT NULL,
	  TENANT_ID VARCHAR(64) NOT NULL,
	  PRIMARY KEY (DICTTYPEID, LOCALE,TENANT_ID)
	);


	ALTER TABLE EOS_DICT_ENTRY ADD 
	  FOREIGN KEY (DICTTYPEID,TENANT_ID) 
	    REFERENCES EOS_DICT_TYPE (DICTTYPEID,TENANT_ID);
	 
	CREATE INDEX EOS_DICT_ENTRYINDEX
	 ON EOS_DICT_ENTRY(DICTTYPEID,DICTID, SEQNO,TENANT_ID);
