@echo off

set PRG=%~dp0

set EOS_DAP_HOME=%PRG:~0,-5%
set PRIMETON_HOME=%PRG:~0,-14%


if not exist "%JAVA_HOME%\bin\java.exe"  set JAVA_HOME=%PRIMETON_HOME%\jdk180

set "JAVA=%JAVA_HOME%\bin\java.exe"

set APP_NAME=BFP-DEMO
set MODE=service
set LOG_FOLDER=%EOS_DAP_HOME%/logs

set EOS_DAP_MEM_OPTS=-Xms512m -Xmx1024m -Xmn256m

set JAVA_OPTS=-server -Djava.net.preferIPv4Stack=true -Duser.timezone=Asia/Shanghai -Dclient.encoding.override=UTF-8 -Dfile.encoding=UTF-8
set JAVA_OPTS=%JAVA_OPTS% %EOS_DAP_MEM_OPTS%
set JAVA_OPTS=%JAVA_OPTS% -DEXTERNAL_CONFIG_DIR=%EOS_DAP_HOME%\config
set JAVA_OPTS=%JAVA_OPTS% -Dloader.path=%EOS_DAP_HOME%\lib 
set JAVA_OPTS=%JAVA_OPTS% -Dlogging.config=%EOS_DAP_HOME%\config\logback-spring.xml

@rem set JAVA_OPTS=%JAVA_OPTS% -javaagent:%EOS_DAP_HOME%\..\..\skywalking-agent\skywalking-agent.jar
@rem set JAVA_OPTS=%JAVA_OPTS% -DSW_AGENT_NAME=%APP_NAME%
@rem set JAVA_OPTS=%JAVA_OPTS% -DSW_AGENT_COLLECTOR_BACKEND_SERVICES=172.50.1.175:11800
@rem set JAVA_OPTS=%JAVA_OPTS% -Dskywalking.trace.ignore_path=/eureka/**,/actuator/eos/**,/nacos/**

@rem set JAVA_OPTS=%JAVA_OPTS% -XX:+UseParNewGC -XX:ParallelGCThreads=4 -XX:MaxTenuringThreshold=9 -XX:+UseConcMarkSweepGC

IF "%1" == "-deubg" set JAVA_OPTS=%JAVA_OPTS% -XX:+HeapDumpOnOutOfMemoryError -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=8787


cd %EOS_DAP_HOME%

FOR /F %%i IN ('dir /b *.jar') DO @set JAR_FILE=%%i
set BOOT_JAR=%EOS_DAP_HOME%\%JAR_FILE%

title %JAR_FILE%
"%JAVA%" %JAVA_OPTS% -jar %BOOT_JAR% %1 %2 %3 
