export default {
	data() {
		return {
			loading: false
		}
	},
	mounted() {
		// this.loading = true
	},
	methods: {
		getAnchors() {
			const anchorDoms = document.getElementsByClassName('anchor')
			const anchorData = []
			anchorDoms.forEach(element => {
				anchorData.push({
					id: element.getAttribute('id'),
					title: element.innerHTML,
					desc: ''
				})
			})
			return anchorData
		},
		loadFormData(processContext, bfpContext) {
			return new Promise(resolve => {
				this.form = bfpContext.formData
				resolve(true)
			})
		},
		beforeSaveFormData(processContext, bfpContext) {
			return new Promise(resolve => {
				// 可以返回一个promise， 也可以直接返回boolean值
				this.$refs['form'].validate(valid => {
					if (valid) {
						resolve(true)
					} else {
						resolve(false)
					}
				})
			})
		},
		saveFormData(processContext, bfpContext) {
			// 如果有异步操作，返回一个promise，否则直接返回form数据
			return new Promise(resolve => {
				resolve(this.form)
			})
		},
		afterSaveFormData(processContext, bfpContext) {
			// 如果有异步操作，返回一个promise，否则直接返回form数据
			return new Promise(resolve => {
				resolve()
			})
		}
	}
}
